package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入商品记录状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-22
 */
public enum ImportGoodInfoStatus {

    _1("1", "待处理"),
    _2("2", "处理中"),
    _3("3", "全部失败"),
    _4("4", "部分失败"),
    _5("5", "成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImportGoodInfoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportGoodInfoStatus fromCode(String code) {
        return Stream.of(ImportGoodInfoStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
