package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum BillType {

    _1("1", "对项配件账单"),
    _2("2", "非对项配件账单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillType fromCode(String code) {
        return Stream.of(BillType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
