package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 商品状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum GoodsStatus {

    _1("1", "待确认"),
    _2("2", "已启用"),
    _3("3", "已禁用"),
    _4("4", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsStatus fromCode(String code) {
        return Stream.of(GoodsStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
