package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入商品明细状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum ImportGoodInfoDetailStatus {

    _1("1", "处理中"),
    _2("2", "成功"),
    _3("3", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImportGoodInfoDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportGoodInfoDetailStatus fromCode(String code) {
        return Stream.of(ImportGoodInfoDetailStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
