package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入库存调整状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum ImportInventoryDetailStatus {

    _0("0", "处理中"),
    _1("1", "全部失败"),
    _2("2", "部分成功"),
    _3("3", "全部成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImportInventoryDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportInventoryDetailStatus fromCode(String code) {
        return Stream.of(ImportInventoryDetailStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
