package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
public enum RuleType {

    DEFAULT("default", "默认规则"),
    SINGLE("single", "单一规则");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleType fromCode(String code) {
        return Stream.of(RuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
