package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据配单计算依据
 * </p>
 *
 * @author ultraman
 * @since 2023-06-28
 */
public enum BillMatchAccordStatus {

    _1("1", "含税金额");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillMatchAccordStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillMatchAccordStatus fromCode(String code) {
        return Stream.of(BillMatchAccordStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
