package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 锁定状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-28
 */
public enum LockStatus {

    _0("0", "未锁定"),
    _1("1", "已锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LockStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LockStatus fromCode(String code) {
        return Stream.of(LockStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
