package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 创建方式
 * </p>
 *
 * @author ultraman
 * @since 2023-06-28
 */
public enum TaxCodeCreateType {

    _1("1", "系统预设"),
    _2("2", "手动创建");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxCodeCreateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxCodeCreateType fromCode(String code) {
        return Stream.of(TaxCodeCreateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
