package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 库存类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-31
 */
public enum InventoryDetailType {

    _1("1", "入库"),
    _2("2", "出库"),
    _3("3", "调整");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InventoryDetailType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InventoryDetailType fromCode(String code) {
        return Stream.of(InventoryDetailType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
