package com.xforceplus.ultraman.app.jccass.metadata.validator;

import com.xforceplus.ultraman.app.jccass.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jccass.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsStatus.class)) {
            isValid = null != GoodsStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMatchAccordStatus.class)) {
            isValid = null != BillMatchAccordStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillMatchAccordStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillMatchDetailStatus.class)) {
            isValid = null != BillMatchDetailStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillMatchDetailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckConfirmStatus.class)) {
            isValid = null != CheckConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoMatchStatus.class)) {
            isValid = null != AutoMatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoMatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoMatchPriorityStatus.class)) {
            isValid = null != AutoMatchPriorityStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoMatchPriorityStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoUploadPlatformStatus.class)) {
            isValid = null != AutoUploadPlatformStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoUploadPlatformStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleUseStatus.class)) {
            isValid = null != RuleUseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleUseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillType.class)) {
            isValid = null != BillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailType.class)) {
            isValid = null != InventoryDetailType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryDetailType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailDirection.class)) {
            isValid = null != InventoryDetailDirection.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryDetailDirection.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryServiceReason.class)) {
            isValid = null != InventoryServiceReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InventoryServiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ImportInvoiceStatus.class)) {
            isValid = null != ImportInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImportInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ConfirmStatus.class)) {
            isValid = null != ConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConfirmStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
