package com.xforceplus.ultraman.app.jccass.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-04-06
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1539853870324695041L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface ImportInvoice {
        static Long id() {
            return 1635937161365786625L;
        }
        static String code() {
            return "importInvoice";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> GOODS_NAME = new TypedField<>(String.class, "goods_name");
        TypedField<String> GOODS_SPEC = new TypedField<>(String.class, "goods_spec");
        TypedField<String> SHORT_TAX_NO_NAME = new TypedField<>(String.class, "short_tax_no_name");
        TypedField<String> GOOD_UNIT = new TypedField<>(String.class, "good_unit");
        TypedField<String> IMPORT_INVOICE_STATUS = new TypedField<>(String.class, "import_invoice_status");
        TypedField<String> MEMO = new TypedField<>(String.class, "memo");
        TypedField<Long> QUANTITY = new TypedField<>(Long.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "purchase_price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        /**
         * 对一关联关系 关联对象 goodsInfo
         */
        TypedField<Long> GOODS_OTM_INVOICE_DETAIL_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface GOODS_OTM_INVOICE_DETAIL {
                static String code () {
                    return "goodsOtmInvoiceDetail" ;
                }
                TypedField<String> NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "goodsOtmInvoiceDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInvoiceDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInvoiceDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "goodsOtmInvoiceDetail.delete_flag");
                TypedField<String> SPECIFICATION = new TypedField<>(String.class, "goodsOtmInvoiceDetail.specification");
                TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.purchase_price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.tax_rate");
                TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.markup_rate");
                TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.stock_quantity");
                TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.sales_price");
                TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_status");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_tax_no");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.seller_tax_no");
                TypedField<String> SHOW_MSG = new TypedField<>(String.class, "goodsOtmInvoiceDetail.show_msg");
                TypedField<String> UNIT = new TypedField<>(String.class, "goodsOtmInvoiceDetail.unit");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.seller_name");
                TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.item_short_name");
                TypedField<String> GOODS_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_no");
                TypedField<String> GOODS_ID = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_id");
                TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.sales_price_with_tax");
            }
        }
    }
    public interface GoodsInfo {
        static Long id() {
            return 1635938638113116162L;
        }
        static String code() {
            return "goodsInfo";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "purchase_price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "markup_rate");
        TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "stock_quantity");
        TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "sales_price");
        TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goods_status");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SHOW_MSG = new TypedField<>(String.class, "show_msg");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "item_short_name");
        TypedField<String> GOODS_NO = new TypedField<>(String.class, "goods_no");
        TypedField<String> GOODS_ID = new TypedField<>(String.class, "goods_id");
        TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "sales_price_with_tax");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InventoryDetail {
        static Long id() {
            return 1635952896763805697L;
        }
        static String code() {
            return "inventoryDetail";
        }
        TypedField<Long> QUANTITY = new TypedField<>(Long.class, "quantity");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> INVENTORY_SERVICE_REASON = new TypedField<>(String.class, "inventory_service_reason");
        TypedField<String> INVENTORY_DETAIL_DIRECTION = new TypedField<>(String.class, "inventory_detail_direction");
        TypedField<String> INVENTORY_DETAIL_TYPE = new TypedField<>(String.class, "inventory_detail_type");
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "business_id");
        TypedField<String> MEMO = new TypedField<>(String.class, "memo");
        TypedField<Long> MANUAL_QUANTITY = new TypedField<>(Long.class, "manual_quantity");
        /**
         * 对一关联关系 关联对象 goodsInfo
         */
        TypedField<Long> GOODS_OTM_INVENTORY_DETAIL_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.id");
        /**
         * 对一关联关系 关联对象 importInvoice
         */
        TypedField<Long> INVOICE_OTO_INVENTORY_ID = new TypedField<>(Long.class, "invoiceOtoInventory.id");
        /**
         * 对一关联关系 关联对象 inventoryMatch
         */
        TypedField<Long> MATCH_INVENTORY_OTO_INVENTORY_ID = new TypedField<>(Long.class, "matchInventoryOtoInventory.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface GOODS_OTM_INVENTORY_DETAIL {
                static String code () {
                    return "goodsOtmInventoryDetail" ;
                }
                TypedField<String> NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.name");
                TypedField<Long> ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "goodsOtmInventoryDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInventoryDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInventoryDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "goodsOtmInventoryDetail.delete_flag");
                TypedField<String> SPECIFICATION = new TypedField<>(String.class, "goodsOtmInventoryDetail.specification");
                TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.purchase_price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.tax_rate");
                TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.markup_rate");
                TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "goodsOtmInventoryDetail.stock_quantity");
                TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.sales_price");
                TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_status");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_tax_no");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.seller_tax_no");
                TypedField<String> SHOW_MSG = new TypedField<>(String.class, "goodsOtmInventoryDetail.show_msg");
                TypedField<String> UNIT = new TypedField<>(String.class, "goodsOtmInventoryDetail.unit");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.seller_name");
                TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.item_short_name");
                TypedField<String> GOODS_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_no");
                TypedField<String> GOODS_ID = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_id");
                TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.sales_price_with_tax");
            }
            interface INVOICE_OTO_INVENTORY {
                static String code () {
                    return "invoiceOtoInventory" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceOtoInventory.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceOtoInventory.invoice_code");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceOtoInventory.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceOtoInventory.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceOtoInventory.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOtoInventory.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceOtoInventory.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceOtoInventory.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceOtoInventory.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceOtoInventory.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceOtoInventory.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceOtoInventory.delete_flag");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceOtoInventory.seller_tax_no");
                TypedField<String> GOODS_NAME = new TypedField<>(String.class, "invoiceOtoInventory.goods_name");
                TypedField<String> GOODS_SPEC = new TypedField<>(String.class, "invoiceOtoInventory.goods_spec");
                TypedField<String> SHORT_TAX_NO_NAME = new TypedField<>(String.class, "invoiceOtoInventory.short_tax_no_name");
                TypedField<String> GOOD_UNIT = new TypedField<>(String.class, "invoiceOtoInventory.good_unit");
                TypedField<String> IMPORT_INVOICE_STATUS = new TypedField<>(String.class, "invoiceOtoInventory.import_invoice_status");
                TypedField<String> MEMO = new TypedField<>(String.class, "invoiceOtoInventory.memo");
                TypedField<Long> QUANTITY = new TypedField<>(Long.class, "invoiceOtoInventory.quantity");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "invoiceOtoInventory.goods_tax_no");
                TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "invoiceOtoInventory.purchase_price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "invoiceOtoInventory.tax_rate");
            }
            interface MATCH_INVENTORY_OTO_INVENTORY {
                static String code () {
                    return "matchInventoryOtoInventory" ;
                }
                TypedField<String> NAME = new TypedField<>(String.class, "matchInventoryOtoInventory.name");
                TypedField<Long> QUANTITY = new TypedField<>(Long.class, "matchInventoryOtoInventory.quantity");
                TypedField<BigDecimal> PRICE = new TypedField<>(BigDecimal.class, "matchInventoryOtoInventory.price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "matchInventoryOtoInventory.tax_rate");
                TypedField<BigDecimal> MATCH_AMOUNT = new TypedField<>(BigDecimal.class, "matchInventoryOtoInventory.match_amount");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchInventoryOtoInventory.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchInventoryOtoInventory.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchInventoryOtoInventory.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchInventoryOtoInventory.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchInventoryOtoInventory.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchInventoryOtoInventory.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchInventoryOtoInventory.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchInventoryOtoInventory.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchInventoryOtoInventory.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchInventoryOtoInventory.delete_flag");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchInventoryOtoInventory.seller_tax_no");
            }
        }
    }
    public interface MatchRules {
        static Long id() {
            return 1635956729946619905L;
        }
        static String code() {
            return "matchRules";
        }
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyer_tax_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> BILL_MATCH_ACCORD_STATUS = new TypedField<>(String.class, "bill_match_accord_status");
        TypedField<String> BILL_MATCH_DETAIL_STATUS = new TypedField<>(String.class, "bill_match_detail_status");
        TypedField<String> CHECK_CONFIRM_STATUS = new TypedField<>(String.class, "check_confirm_status");
        TypedField<String> AUTO_MATCH_STATUS = new TypedField<>(String.class, "auto_match_status");
        TypedField<String> AUTO_MATCH_PRIORITY_STATUS = new TypedField<>(String.class, "auto_match_priority_status");
        TypedField<String> AUTO_UPLOAD_PLATFORM_STATUS = new TypedField<>(String.class, "auto_upload_platform_status");
        TypedField<String> RULE_USE_STATUS = new TypedField<>(String.class, "rule_use_status");
        TypedField<String> BILL_TYPE = new TypedField<>(String.class, "bill_type");
        TypedField<BigDecimal> DETAIL_TOLERANCE = new TypedField<>(BigDecimal.class, "detail_tolerance");
        TypedField<BigDecimal> BILL_TOLERANCE = new TypedField<>(BigDecimal.class, "bill_tolerance");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyer_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
    }
    public interface Bill {
        static Long id() {
            return 1636186664139231233L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<Long> DETAIL_COUNT = new TypedField<>(Long.class, "detail_count");
        TypedField<Long> UNMATCH_DETAIL_COUNT = new TypedField<>(Long.class, "unmatch_detail_count");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> MATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "match_amount_with_tax");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<Long> MATCH_DETAIL_COUNT = new TypedField<>(Long.class, "match_detail_count");
        TypedField<BigDecimal> UNMATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "unmatch_amount_with_tax");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyer_tax_no");
        TypedField<String> MATCH_FAIL_REASON = new TypedField<>(String.class, "match_fail_reason");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyer_name");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> MATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "match_amount_without_tax");
        TypedField<BigDecimal> UNMATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unmatch_amount_without_tax");
        TypedField<String> RAW_BILL_INFO = new TypedField<>(String.class, "raw_bill_info");
        TypedField<String> CONFIRM_STATUS = new TypedField<>(String.class, "confirm_status");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface BillDetail {
        static Long id() {
            return 1636189313124859906L;
        }
        static String code() {
            return "billDetail";
        }
        TypedField<String> DETAIL_NO = new TypedField<>(String.class, "detail_no");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<Long> QUANTITY = new TypedField<>(Long.class, "quantity");
        TypedField<BigDecimal> PRICE = new TypedField<>(BigDecimal.class, "price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "item_short_name");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> MATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "match_amount_without_tax");
        TypedField<BigDecimal> UNMATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "unmatch_amount_without_tax");
        TypedField<BigDecimal> MATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "match_amount_with_tax");
        TypedField<BigDecimal> UNMATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "unmatch_amount_with_tax");
        /**
         * 对一关联关系 关联对象 bill
         */
        TypedField<Long> BILL_OTM_DETAIL_ID = new TypedField<>(Long.class, "billOtmDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_OTM_DETAIL {
                static String code () {
                    return "billOtmDetail" ;
                }
                TypedField<String> BILL_NO = new TypedField<>(String.class, "billOtmDetail.bill_no");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "billOtmDetail.match_status");
                TypedField<Long> DETAIL_COUNT = new TypedField<>(Long.class, "billOtmDetail.detail_count");
                TypedField<Long> UNMATCH_DETAIL_COUNT = new TypedField<>(Long.class, "billOtmDetail.unmatch_detail_count");
                TypedField<Long> ID = new TypedField<>(Long.class, "billOtmDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billOtmDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billOtmDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billOtmDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billOtmDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billOtmDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billOtmDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billOtmDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billOtmDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billOtmDetail.delete_flag");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.amount_with_tax");
                TypedField<BigDecimal> MATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.match_amount_with_tax");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billOtmDetail.seller_tax_no");
                TypedField<Long> MATCH_DETAIL_COUNT = new TypedField<>(Long.class, "billOtmDetail.match_detail_count");
                TypedField<BigDecimal> UNMATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.unmatch_amount_with_tax");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "billOtmDetail.buyer_tax_no");
                TypedField<String> MATCH_FAIL_REASON = new TypedField<>(String.class, "billOtmDetail.match_fail_reason");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billOtmDetail.seller_name");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "billOtmDetail.buyer_name");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "billOtmDetail.invoice_type");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.amount_without_tax");
                TypedField<BigDecimal> MATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.match_amount_without_tax");
                TypedField<BigDecimal> UNMATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billOtmDetail.unmatch_amount_without_tax");
                TypedField<String> RAW_BILL_INFO = new TypedField<>(String.class, "billOtmDetail.raw_bill_info");
                TypedField<String> CONFIRM_STATUS = new TypedField<>(String.class, "billOtmDetail.confirm_status");
            }
        }
    }
    public interface InventoryMatch {
        static Long id() {
            return 1636192091402977282L;
        }
        static String code() {
            return "inventoryMatch";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<Long> QUANTITY = new TypedField<>(Long.class, "quantity");
        TypedField<BigDecimal> PRICE = new TypedField<>(BigDecimal.class, "price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<BigDecimal> MATCH_AMOUNT = new TypedField<>(BigDecimal.class, "match_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        /**
         * 对一关联关系 关联对象 billDetail
         */
        TypedField<Long> BILL_DETAIL_OTM_INVENTORY_ID = new TypedField<>(Long.class, "billDetailOtmInventory.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_DETAIL_OTM_INVENTORY {
                static String code () {
                    return "billDetailOtmInventory" ;
                }
                TypedField<String> DETAIL_NO = new TypedField<>(String.class, "billDetailOtmInventory.detail_no");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "billDetailOtmInventory.match_status");
                TypedField<Long> QUANTITY = new TypedField<>(Long.class, "billDetailOtmInventory.quantity");
                TypedField<BigDecimal> PRICE = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.tax_rate");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.amount_with_tax");
                TypedField<Long> ID = new TypedField<>(Long.class, "billDetailOtmInventory.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billDetailOtmInventory.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billDetailOtmInventory.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billDetailOtmInventory.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billDetailOtmInventory.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billDetailOtmInventory.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billDetailOtmInventory.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billDetailOtmInventory.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billDetailOtmInventory.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billDetailOtmInventory.delete_flag");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billDetailOtmInventory.seller_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billDetailOtmInventory.seller_name");
                TypedField<String> SPECIFICATION = new TypedField<>(String.class, "billDetailOtmInventory.specification");
                TypedField<String> ITEM_NAME = new TypedField<>(String.class, "billDetailOtmInventory.item_name");
                TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "billDetailOtmInventory.item_short_name");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "billDetailOtmInventory.goods_tax_no");
                TypedField<String> UNIT = new TypedField<>(String.class, "billDetailOtmInventory.unit");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.amount_without_tax");
                TypedField<BigDecimal> MATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.match_amount_without_tax");
                TypedField<BigDecimal> UNMATCH_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.unmatch_amount_without_tax");
                TypedField<BigDecimal> MATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.match_amount_with_tax");
                TypedField<BigDecimal> UNMATCH_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billDetailOtmInventory.unmatch_amount_with_tax");
            }
        }
    }
    public interface TaxCode {
        static Long id() {
            return 1636266481079599106L;
        }
        static String code() {
            return "taxCode";
        }
        TypedField<String> CASS_TAX_CODE = new TypedField<>(String.class, "cass_tax_code");
        TypedField<String> TAX_CODE = new TypedField<>(String.class, "tax_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
    }
    public interface SupplierInfo {
        static Long id() {
            return 1642085066386501634L;
        }
        static String code() {
            return "supplierInfo";
        }
        TypedField<String> COMPANY_ID = new TypedField<>(String.class, "company_id");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "company_name");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "tax_no");
        TypedField<String> ACCOUNT = new TypedField<>(String.class, "account");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
