package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 自动匹配优先级规则
 * </p>
 *
 * @author ultraman
 * @since 2023-04-10
 */
public enum AutoMatchPriorityStatus {

    _1("1", "单价优先"),
    _2("2", "数量优先");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoMatchPriorityStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoMatchPriorityStatus fromCode(String code) {
        return Stream.of(AutoMatchPriorityStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
