package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否自动上传票易通平台
 * </p>
 *
 * @author ultraman
 * @since 2023-04-10
 */
public enum AutoUploadPlatformStatus {

    _1("1", "是"),
    _0("0", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AutoUploadPlatformStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoUploadPlatformStatus fromCode(String code) {
        return Stream.of(AutoUploadPlatformStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
