package com.xforceplus.ultraman.app.jccass.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-10
 */
public enum InvoiceType {

    C("c", "专票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code) {
        return Stream.of(InvoiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
