package com.xforceplus.ultraman.app.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jccass.entity.SupplierInfo;
import com.xforceplus.ultraman.app.jccass.service.ISupplierInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-21
 */
@RestController
public class SupplierInfoController {

  @Autowired
  private ISupplierInfoService supplierInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supplierInfo ${table.comment}
   * @return
   */
  @GetMapping("/supplierinfos" )
  public XfR getSupplierInfos(XfPage page, SupplierInfo supplierInfo) {
    return XfR.ok(supplierInfoServiceImpl.page(page, Wrappers.query(supplierInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/supplierinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supplierInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param supplierInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/supplierinfos")
  public XfR save(@RequestBody SupplierInfo supplierInfo) {
     return XfR.ok(supplierInfoServiceImpl.save(supplierInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param supplierInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/supplierinfos/{id}")
  public XfR putUpdate(@RequestBody SupplierInfo supplierInfo,@PathVariable Long id) {
      supplierInfo.setId(id);
      return XfR.ok(supplierInfoServiceImpl.updateById(supplierInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param supplierInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/supplierinfos/{id}")
  public XfR patchUpdate(@RequestBody SupplierInfo supplierInfo,@PathVariable Long id) {
      SupplierInfo upsupplierInfo = supplierInfoServiceImpl.getById(id);
      if(upsupplierInfo != null){
        upsupplierInfo = ObjectCopyUtils.copyProperties(supplierInfo,upsupplierInfo,true);
      }
      return XfR.ok(supplierInfoServiceImpl.updateById(upsupplierInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/supplierinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supplierInfoServiceImpl.removeById(id));
  }

  @PostMapping("/supplierinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "supplier_info");
     params.put("request", condition);

     return XfR.ok(supplierInfoServiceImpl.querys(params));
  }

}
