package com.xforceplus.ultraman.app.jcchengengyu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchengengyu.entity.A001;
import com.xforceplus.ultraman.app.jcchengengyu.service.IA001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class A001Controller {

  @Autowired
  private IA001Service a001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param a001 ${table.comment}
   * @return
   */
  @GetMapping("/a001s" )
  public XfR getA001s(XfPage page, A001 a001) {
    return XfR.ok(a001ServiceImpl.page(page, Wrappers.query(a001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/a001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(a001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param a001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/a001s")
  public XfR save(@RequestBody A001 a001) {
     return XfR.ok(a001ServiceImpl.save(a001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param a001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/a001s/{id}")
  public XfR putUpdate(@RequestBody A001 a001,@PathVariable Long id) {
      a001.setId(id);
      return XfR.ok(a001ServiceImpl.updateById(a001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param a001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/a001s/{id}")
  public XfR patchUpdate(@RequestBody A001 a001,@PathVariable Long id) {
      A001 upa001 = a001ServiceImpl.getById(id);
      if(upa001 != null){
        upa001 = ObjectCopyUtils.copyProperties(a001,upa001,true);
      }
      return XfR.ok(a001ServiceImpl.updateById(upa001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/a001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(a001ServiceImpl.removeById(id));
  }

  @PostMapping("/a001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a001");
     params.put("request", condition);

     return XfR.ok(a001ServiceImpl.querys(params));
  }

}
