package com.xforceplus.ultraman.app.jcchengengyu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchengengyu.entity.Testdt;
import com.xforceplus.ultraman.app.jcchengengyu.service.ITestdtService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class TestdtController {

  @Autowired
  private ITestdtService testdtServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testdt ${table.comment}
   * @return
   */
  @GetMapping("/testdts" )
  public XfR getTestdts(XfPage page, Testdt testdt) {
    return XfR.ok(testdtServiceImpl.page(page, Wrappers.query(testdt)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testdts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testdtServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testdt ${table.comment}
   * @return XfR
   */
  @PostMapping("/testdts")
  public XfR save(@RequestBody Testdt testdt) {
     return XfR.ok(testdtServiceImpl.save(testdt));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testdt ${table.comment}
   * @return XfR
   */
  @PutMapping("/testdts/{id}")
  public XfR putUpdate(@RequestBody Testdt testdt,@PathVariable Long id) {
      testdt.setId(id);
      return XfR.ok(testdtServiceImpl.updateById(testdt));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testdt ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testdts/{id}")
  public XfR patchUpdate(@RequestBody Testdt testdt,@PathVariable Long id) {
      Testdt uptestdt = testdtServiceImpl.getById(id);
      if(uptestdt != null){
        uptestdt = ObjectCopyUtils.copyProperties(testdt,uptestdt,true);
      }
      return XfR.ok(testdtServiceImpl.updateById(uptestdt));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testdts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testdtServiceImpl.removeById(id));
  }

  @PostMapping("/testdts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testdt");
     params.put("request", condition);

     return XfR.ok(testdtServiceImpl.querys(params));
  }

}
