package com.xforceplus.ultraman.app.jcchenhuping.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字申请状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum ApplyingStatus1683272286488 {

    _1("1", "待申请"),
    _2("2", "申请中"),
    _3("3", "已申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyingStatus1683272286488(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyingStatus1683272286488 fromCode(String code) {
        return Stream.of(ApplyingStatus1683272286488.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
