package com.xforceplus.ultraman.app.jcchenhuping.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 库存业务原因
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum InventoryServiceReason {

    _1("1", "发票导入"),
    _2("2", "手动录入"),
    _3("3", "配单出库"),
    _4("4", "发票核销手动调整"),
    _5("5", "取消-配单出库"),
    _6("6", "负数明细配单"),
    _7("7", "取消-负数明细配单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InventoryServiceReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InventoryServiceReason fromCode(String code) {
        return Stream.of(InventoryServiceReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
