package com.xforceplus.ultraman.app.jcchenhuping.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum InvoiceSource {

    _1("1", "4.0 平台"),
    _2("2", "3.0 平台"),
    _3("3", "税件低频"),
    _4("4", "税件归集"),
    _9("9", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code) {
        return Stream.of(InvoiceSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
