package com.xforceplus.ultraman.app.jcchenhuping.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-06-16
*/
public class EntityMeta {
    public interface FlowReplayLog {
        static Long id() {
            return 1651770809181585410L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FilterSalesInvoiceItem {
        static Long id() {
            return 1654083939478900738L;
        }
        static String code() {
            return "filterSalesInvoiceItem";
        }
        TypedField<LocalDateTime> TOLL_START_DATE = new TypedField<>(LocalDateTime.class, "tollStartDate");
        TypedField<LocalDateTime> TOLL_END_DATE = new TypedField<>(LocalDateTime.class, "tollEndDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> GOODS_TAX_NO_VERSION = new TypedField<>(String.class, "goodsTaxNoVersion");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        /**
         * 对一关联关系 关联对象 filterSalesInvoice
         */
        TypedField<Long> MAIN_DETAIL_REL_ID = new TypedField<>(Long.class, "mainDetailRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MAIN_DETAIL_REL {
                static String code () {
                    return "mainDetailRel" ;
                }
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "mainDetailRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "mainDetailRel.originalDateIssued");
                TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "mainDetailRel.electronicSignature");
                TypedField<String> CHANNEL = new TypedField<>(String.class, "mainDetailRel.channel");
                TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "mainDetailRel.printContentFlag");
                TypedField<String> REVERSER = new TypedField<>(String.class, "mainDetailRel.reverser");
                TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "mainDetailRel.printStatus");
                TypedField<LocalDateTime> CANCELLATION_TIME = new TypedField<>(LocalDateTime.class, "mainDetailRel.cancellationTime");
                TypedField<String> CANCELLATION_USER = new TypedField<>(String.class, "mainDetailRel.cancellationUser");
                TypedField<String> EXT1 = new TypedField<>(String.class, "mainDetailRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "mainDetailRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "mainDetailRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "mainDetailRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "mainDetailRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "mainDetailRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "mainDetailRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "mainDetailRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "mainDetailRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "mainDetailRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "mainDetailRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "mainDetailRel.ext12");
                TypedField<Long> ID = new TypedField<>(Long.class, "mainDetailRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "mainDetailRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "mainDetailRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "mainDetailRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "mainDetailRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "mainDetailRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "mainDetailRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "mainDetailRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "mainDetailRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "mainDetailRel.delete_flag");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "mainDetailRel.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "mainDetailRel.invoiceCode");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "mainDetailRel.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "mainDetailRel.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "mainDetailRel.amountWithTax");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "mainDetailRel.buyerName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "mainDetailRel.buyerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "mainDetailRel.sellerName");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "mainDetailRel.sellerTaxNo");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "mainDetailRel.machineCode");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "mainDetailRel.checkCode");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "mainDetailRel.cipherText");
                TypedField<String> PAYEE = new TypedField<>(String.class, "mainDetailRel.payee");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "mainDetailRel.reviewer");
                TypedField<String> ISSUER = new TypedField<>(String.class, "mainDetailRel.issuer");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "mainDetailRel.buyerNo");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "mainDetailRel.sellerNo");
                TypedField<LocalDateTime> REVERSE_TIME = new TypedField<>(LocalDateTime.class, "mainDetailRel.reverseTime");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "mainDetailRel.redLetterNumber");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "mainDetailRel.pdfUrl");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "mainDetailRel.buyerAddress");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "mainDetailRel.buyerTel");
                TypedField<String> BUYER_ADDRESS_TEL = new TypedField<>(String.class, "mainDetailRel.buyerAddressTel");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "mainDetailRel.buyerBankName");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "mainDetailRel.buyerBankAccount");
                TypedField<String> BUYER_BANK_INFO = new TypedField<>(String.class, "mainDetailRel.buyerBankInfo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "mainDetailRel.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "mainDetailRel.sellerTel");
                TypedField<String> SELLER_ADDRESS_TEL = new TypedField<>(String.class, "mainDetailRel.sellerAddressTel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "mainDetailRel.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "mainDetailRel.sellerBankAccount");
                TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "mainDetailRel.sellerBankInfo");
                TypedField<String> REMARK = new TypedField<>(String.class, "mainDetailRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "mainDetailRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "mainDetailRel.originalInvoiceCode");
                TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "mainDetailRel.invoiceKind");
                TypedField<String> STATUS = new TypedField<>(String.class, "mainDetailRel.status");
                TypedField<String> REVERSE_STATUS = new TypedField<>(String.class, "mainDetailRel.reverseStatus");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "mainDetailRel.invoiceColor");
                TypedField<String> VIEW_URL = new TypedField<>(String.class, "mainDetailRel.viewUrl");
                TypedField<String> XML_URL = new TypedField<>(String.class, "mainDetailRel.xmlUrl");
                TypedField<String> OFD_URL = new TypedField<>(String.class, "mainDetailRel.ofdUrl");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "mainDetailRel.taxRate");
                TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "mainDetailRel.accountType");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "mainDetailRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "mainDetailRel.bizOrderNo");
                TypedField<String> CIPHER_TEXT_Q_R_CODE = new TypedField<>(String.class, "mainDetailRel.cipherTextQRCode");
                TypedField<String> INVOICE_STYLE_TYPE = new TypedField<>(String.class, "mainDetailRel.invoiceStyleType");
                TypedField<Boolean> SALE_LIST_FILE_FLAG = new TypedField<>(Boolean.class, "mainDetailRel.saleListFileFlag");
                TypedField<String> SPECIAL_TYPE = new TypedField<>(String.class, "mainDetailRel.specialType");
                TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "mainDetailRel.sellerTenantCode");
                TypedField<String> BUYER_TENANT_CODE = new TypedField<>(String.class, "mainDetailRel.buyerTenantCode");
                TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "mainDetailRel.dataSource");
                TypedField<String> INVOICE_SOURCE = new TypedField<>(String.class, "mainDetailRel.invoiceSource");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "mainDetailRel.invoiceType");
                TypedField<String> CUSTOM_RED_FLUSH_REASON = new TypedField<>(String.class, "mainDetailRel.customRedFlushReason");
                TypedField<String> CUSTOM_ABANDON_REASON = new TypedField<>(String.class, "mainDetailRel.customAbandonReason");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "mainDetailRel.specialInvoiceFlag");
                TypedField<String> SPECIAL_ADDITIONS = new TypedField<>(String.class, "mainDetailRel.specialAdditions");
                TypedField<String> SOURCE = new TypedField<>(String.class, "mainDetailRel.source");
                TypedField<LocalDateTime> DATE_ISSUED = new TypedField<>(LocalDateTime.class, "mainDetailRel.dateIssued");
            }
        }
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1651770808187535362L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FilterSalesInvoice {
        static Long id() {
            return 1654083939659255810L;
        }
        static String code() {
            return "filterSalesInvoice";
        }
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalDateIssued");
        TypedField<String> ELECTRONIC_SIGNATURE = new TypedField<>(String.class, "electronicSignature");
        TypedField<String> CHANNEL = new TypedField<>(String.class, "channel");
        TypedField<String> PRINT_CONTENT_FLAG = new TypedField<>(String.class, "printContentFlag");
        TypedField<String> REVERSER = new TypedField<>(String.class, "reverser");
        TypedField<String> PRINT_STATUS = new TypedField<>(String.class, "printStatus");
        TypedField<LocalDateTime> CANCELLATION_TIME = new TypedField<>(LocalDateTime.class, "cancellationTime");
        TypedField<String> CANCELLATION_USER = new TypedField<>(String.class, "cancellationUser");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machineCode");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "checkCode");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipherText");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> REVIEWER = new TypedField<>(String.class, "reviewer");
        TypedField<String> ISSUER = new TypedField<>(String.class, "issuer");
        TypedField<String> BUYER_NO = new TypedField<>(String.class, "buyerNo");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<LocalDateTime> REVERSE_TIME = new TypedField<>(LocalDateTime.class, "reverseTime");
        TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterNumber");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdfUrl");
        TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "buyerAddress");
        TypedField<String> BUYER_TEL = new TypedField<>(String.class, "buyerTel");
        TypedField<String> BUYER_ADDRESS_TEL = new TypedField<>(String.class, "buyerAddressTel");
        TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "buyerBankName");
        TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "buyerBankAccount");
        TypedField<String> BUYER_BANK_INFO = new TypedField<>(String.class, "buyerBankInfo");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_ADDRESS_TEL = new TypedField<>(String.class, "sellerAddressTel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> SELLER_BANK_INFO = new TypedField<>(String.class, "sellerBankInfo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> INVOICE_KIND = new TypedField<>(String.class, "invoiceKind");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> REVERSE_STATUS = new TypedField<>(String.class, "reverseStatus");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<String> VIEW_URL = new TypedField<>(String.class, "viewUrl");
        TypedField<String> XML_URL = new TypedField<>(String.class, "xmlUrl");
        TypedField<String> OFD_URL = new TypedField<>(String.class, "ofdUrl");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> ACCOUNT_TYPE = new TypedField<>(String.class, "accountType");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "taxInvoiceSource");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderNo");
        TypedField<String> CIPHER_TEXT_Q_R_CODE = new TypedField<>(String.class, "cipherTextQRCode");
        TypedField<String> INVOICE_STYLE_TYPE = new TypedField<>(String.class, "invoiceStyleType");
        TypedField<Boolean> SALE_LIST_FILE_FLAG = new TypedField<>(Boolean.class, "saleListFileFlag");
        TypedField<String> SPECIAL_TYPE = new TypedField<>(String.class, "specialType");
        TypedField<String> SELLER_TENANT_CODE = new TypedField<>(String.class, "sellerTenantCode");
        TypedField<String> BUYER_TENANT_CODE = new TypedField<>(String.class, "buyerTenantCode");
        TypedField<String> DATA_SOURCE = new TypedField<>(String.class, "dataSource");
        TypedField<String> INVOICE_SOURCE = new TypedField<>(String.class, "invoiceSource");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> CUSTOM_RED_FLUSH_REASON = new TypedField<>(String.class, "customRedFlushReason");
        TypedField<String> CUSTOM_ABANDON_REASON = new TypedField<>(String.class, "customAbandonReason");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "specialInvoiceFlag");
        TypedField<String> SPECIAL_ADDITIONS = new TypedField<>(String.class, "specialAdditions");
        TypedField<String> SOURCE = new TypedField<>(String.class, "source");
        TypedField<LocalDateTime> DATE_ISSUED = new TypedField<>(LocalDateTime.class, "dateIssued");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1651770807424172034L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1651770806593699841L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface RedNoObj {
        static Long id() {
            return 1654389994402938882L;
        }
        static String code() {
            return "redNoObj";
        }
        TypedField<String> REQUEST_BILL_NO = new TypedField<>(String.class, "requestBillNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<LocalDateTime> APPLY_DATE = new TypedField<>(LocalDateTime.class, "applyDate");
        TypedField<LocalDateTime> PAPER_DRAW_DATE = new TypedField<>(LocalDateTime.class, "paperDrawDate");
        TypedField<String> SELLER_NUMBER = new TypedField<>(String.class, "sellerNumber");
        TypedField<String> APPLY_IDENTITY = new TypedField<>(String.class, "applyIdentity");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> APPLYING_STATUS = new TypedField<>(String.class, "applyingStatus");
        TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "originInvoiceType");
        /**
         * 对一关联关系 关联对象 null
         */
        TypedField<Long> TO_COMPANY_ID = new TypedField<>(Long.class, "toCompany.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface TO_COMPANY {
                static String code () {
                    return "toCompany" ;
                }
            }
        }
    }
    public interface BillRedNo1683270588662 {
        static Long id() {
            return 1654383222564913153L;
        }
        static String code() {
            return "billRedNo1683270588662";
        }
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "billNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface DownPDF {
        static Long id() {
            return 1654399061074219009L;
        }
        static String code() {
            return "downPDF";
        }
        TypedField<String> GENERATE_MODEL = new TypedField<>(String.class, "generateModel");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Hotel {
        static Long id() {
            return 1654691542908612609L;
        }
        static String code() {
            return "hotel";
        }
        TypedField<String> HOTEL_UNIFY_NO = new TypedField<>(String.class, "hotelUnifyNo");
        TypedField<String> HOTEL_NAME = new TypedField<>(String.class, "hotelName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Test002oqs {
        static Long id() {
            return 1668494576687054849L;
        }
        static String code() {
            return "test002oqs";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> DESC = new TypedField<>(String.class, "desc");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Test003 {
        static Long id() {
            return 1668561958596050946L;
        }
        static String code() {
            return "test003";
        }
        TypedField<String> CODE = new TypedField<>(String.class, "code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface Detail002 {
        static Long id() {
            return 1668802368950042626L;
        }
        static String code() {
            return "detail002";
        }
        TypedField<String> DE002 = new TypedField<>(String.class, "de002");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 detail001
         */
        TypedField<Long> THREE_BY_ANY001_ID = new TypedField<>(Long.class, "threeByAny001.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface THREE_BY_ANY001 {
                static String code () {
                    return "threeByAny001" ;
                }
                TypedField<String> DE = new TypedField<>(String.class, "threeByAny001.de");
                TypedField<Long> ID = new TypedField<>(Long.class, "threeByAny001.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "threeByAny001.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "threeByAny001.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "threeByAny001.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "threeByAny001.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "threeByAny001.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "threeByAny001.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "threeByAny001.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "threeByAny001.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "threeByAny001.delete_flag");
            }
        }
    }
    public interface Title {
        static Long id() {
            return 1668801992523354114L;
        }
        static String code() {
            return "title";
        }
        TypedField<String> TITLE = new TypedField<>(String.class, "title");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface Detail001 {
        static Long id() {
            return 1668802212132917250L;
        }
        static String code() {
            return "detail001";
        }
        TypedField<String> DE = new TypedField<>(String.class, "de");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 title
         */
        TypedField<Long> ONE_BY_ANY001_ID = new TypedField<>(Long.class, "oneByAny001.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ONE_BY_ANY001 {
                static String code () {
                    return "oneByAny001" ;
                }
                TypedField<String> TITLE = new TypedField<>(String.class, "oneByAny001.title");
                TypedField<Long> ID = new TypedField<>(Long.class, "oneByAny001.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "oneByAny001.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "oneByAny001.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "oneByAny001.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "oneByAny001.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "oneByAny001.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "oneByAny001.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "oneByAny001.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "oneByAny001.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "oneByAny001.delete_flag");
            }
        }
    }
    public interface InventoryDetail {
        static Long id() {
            return 1668881672195080193L;
        }
        static String code() {
            return "inventoryDetail";
        }
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> MEMO = new TypedField<>(String.class, "memo");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> MANUAL_QUANTITY = new TypedField<>(BigDecimal.class, "manual_quantity");
        TypedField<String> CREATE_PERSON_NAME = new TypedField<>(String.class, "create_person_name");
        TypedField<String> CREATE_PERSON_ACCOUNT = new TypedField<>(String.class, "create_person_account");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVENTORY_SERVICE_REASON = new TypedField<>(String.class, "inventory_service_reason");
        TypedField<String> INVENTORY_DETAIL_DIRECTION = new TypedField<>(String.class, "inventory_detail_direction");
        TypedField<String> INVENTORY_DETAIL_TYPE = new TypedField<>(String.class, "inventory_detail_type");
        /**
         * 对一关联关系 关联对象 goodsInfo
         */
        TypedField<Long> GOODS_OTM_INVENTORY_DETAIL_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface GOODS_OTM_INVENTORY_DETAIL {
                static String code () {
                    return "goodsOtmInventoryDetail" ;
                }
                TypedField<String> NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.name");
                TypedField<String> SPECIFICATION = new TypedField<>(String.class, "goodsOtmInventoryDetail.specification");
                TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.purchase_price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.tax_rate");
                TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.markup_rate");
                TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "goodsOtmInventoryDetail.stock_quantity");
                TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.sales_price");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_tax_no");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.seller_tax_no");
                TypedField<String> SHOW_MSG = new TypedField<>(String.class, "goodsOtmInventoryDetail.show_msg");
                TypedField<String> UNIT = new TypedField<>(String.class, "goodsOtmInventoryDetail.unit");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.seller_name");
                TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.item_short_name");
                TypedField<String> GOODS_NO = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_no");
                TypedField<String> GOODS_ID = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_id");
                TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "goodsOtmInventoryDetail.sales_price_with_tax");
                TypedField<Long> MANUAL_QUANTITY = new TypedField<>(Long.class, "goodsOtmInventoryDetail.manual_quantity");
                TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "goodsOtmInventoryDetail.tax_pre_con");
                TypedField<String> SPECIFICATION_OLD = new TypedField<>(String.class, "goodsOtmInventoryDetail.specification_old");
                TypedField<Long> ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "goodsOtmInventoryDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInventoryDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInventoryDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInventoryDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInventoryDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "goodsOtmInventoryDetail.delete_flag");
                TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_status");
                TypedField<String> COVER_RULE = new TypedField<>(String.class, "goodsOtmInventoryDetail.cover_rule");
                TypedField<String> GOODS_SOURCE = new TypedField<>(String.class, "goodsOtmInventoryDetail.goods_source");
            }
        }
    }
    public interface ImportInvoice {
        static Long id() {
            return 1668881728720719874L;
        }
        static String code() {
            return "importInvoice";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> GOODS_NAME = new TypedField<>(String.class, "goods_name");
        TypedField<String> GOODS_SPEC = new TypedField<>(String.class, "goods_spec");
        TypedField<String> SHORT_TAX_NO_NAME = new TypedField<>(String.class, "short_tax_no_name");
        TypedField<String> GOOD_UNIT = new TypedField<>(String.class, "good_unit");
        TypedField<String> MEMO = new TypedField<>(String.class, "memo");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "purchase_price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<LocalDateTime> IN_STOCK_TIME = new TypedField<>(LocalDateTime.class, "in_stock_time");
        TypedField<String> GOODS_SPEC_OLD = new TypedField<>(String.class, "goods_spec_old");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IMPORT_INVOICE_STATUS = new TypedField<>(String.class, "import_invoice_status");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        /**
         * 对一关联关系 关联对象 goodsInfo
         */
        TypedField<Long> GOODS_OTM_INVOICE_DETAIL_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface GOODS_OTM_INVOICE_DETAIL {
                static String code () {
                    return "goodsOtmInvoiceDetail" ;
                }
                TypedField<String> NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.name");
                TypedField<String> SPECIFICATION = new TypedField<>(String.class, "goodsOtmInvoiceDetail.specification");
                TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.purchase_price");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.tax_rate");
                TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.markup_rate");
                TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.stock_quantity");
                TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.sales_price");
                TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_tax_no");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.seller_tax_no");
                TypedField<String> SHOW_MSG = new TypedField<>(String.class, "goodsOtmInvoiceDetail.show_msg");
                TypedField<String> UNIT = new TypedField<>(String.class, "goodsOtmInvoiceDetail.unit");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.seller_name");
                TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.item_short_name");
                TypedField<String> GOODS_NO = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_no");
                TypedField<String> GOODS_ID = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_id");
                TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "goodsOtmInvoiceDetail.sales_price_with_tax");
                TypedField<Long> MANUAL_QUANTITY = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.manual_quantity");
                TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "goodsOtmInvoiceDetail.tax_pre_con");
                TypedField<String> SPECIFICATION_OLD = new TypedField<>(String.class, "goodsOtmInvoiceDetail.specification_old");
                TypedField<Long> ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "goodsOtmInvoiceDetail.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInvoiceDetail.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "goodsOtmInvoiceDetail.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "goodsOtmInvoiceDetail.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "goodsOtmInvoiceDetail.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "goodsOtmInvoiceDetail.delete_flag");
                TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_status");
                TypedField<String> COVER_RULE = new TypedField<>(String.class, "goodsOtmInvoiceDetail.cover_rule");
                TypedField<String> GOODS_SOURCE = new TypedField<>(String.class, "goodsOtmInvoiceDetail.goods_source");
            }
        }
    }
    public interface GoodsInfo {
        static Long id() {
            return 1668881620503482370L;
        }
        static String code() {
            return "goodsInfo";
        }
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "purchase_price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "markup_rate");
        TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "stock_quantity");
        TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "sales_price");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SHOW_MSG = new TypedField<>(String.class, "show_msg");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "item_short_name");
        TypedField<String> GOODS_NO = new TypedField<>(String.class, "goods_no");
        TypedField<String> GOODS_ID = new TypedField<>(String.class, "goods_id");
        TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "sales_price_with_tax");
        TypedField<Long> MANUAL_QUANTITY = new TypedField<>(Long.class, "manual_quantity");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> SPECIFICATION_OLD = new TypedField<>(String.class, "specification_old");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goods_status");
        TypedField<String> COVER_RULE = new TypedField<>(String.class, "cover_rule");
        TypedField<String> GOODS_SOURCE = new TypedField<>(String.class, "goods_source");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface ExtendCode {
        static Long id() {
            return 1669522218814640130L;
        }
        static String code() {
            return "extendCode";
        }
        TypedField<String> CODE1 = new TypedField<>(String.class, "code1");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> NAME = new TypedField<>(String.class, "name");
        TypedField<String> SPECIFICATION = new TypedField<>(String.class, "specification");
        TypedField<BigDecimal> PURCHASE_PRICE = new TypedField<>(BigDecimal.class, "purchase_price");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<BigDecimal> MARKUP_RATE = new TypedField<>(BigDecimal.class, "markup_rate");
        TypedField<Long> STOCK_QUANTITY = new TypedField<>(Long.class, "stock_quantity");
        TypedField<BigDecimal> SALES_PRICE = new TypedField<>(BigDecimal.class, "sales_price");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SHOW_MSG = new TypedField<>(String.class, "show_msg");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "item_short_name");
        TypedField<String> GOODS_NO = new TypedField<>(String.class, "goods_no");
        TypedField<String> GOODS_ID = new TypedField<>(String.class, "goods_id");
        TypedField<BigDecimal> SALES_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "sales_price_with_tax");
        TypedField<Long> MANUAL_QUANTITY = new TypedField<>(Long.class, "manual_quantity");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> SPECIFICATION_OLD = new TypedField<>(String.class, "specification_old");
        TypedField<String> GOODS_STATUS = new TypedField<>(String.class, "goods_status");
        TypedField<String> COVER_RULE = new TypedField<>(String.class, "cover_rule");
        TypedField<String> GOODS_SOURCE = new TypedField<>(String.class, "goods_source");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
}
