package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.Test003;
import com.xforceplus.ultraman.app.jcchenhuping.service.ITest003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test003前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class Test003Controller {

  @Autowired
  private ITest003Service test003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test003 test003
   * @return
   */
  @GetMapping("/test003s" )
  public XfR getTest003s(XfPage page, Test003 test003) {
    return XfR.ok(test003ServiceImpl.page(page, Wrappers.query(test003)));
  }

  /**
   * 通过id查询test003
   * @param  id
   * @return XfR
   */
  @GetMapping("/test003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test003ServiceImpl.getById(id));
  }

  /**
   * 新增test003
   * @param test003 test003
   * @return XfR
   */
  @PostMapping("/test003s")
  public XfR save(@RequestBody Test003 test003) {
     return XfR.ok(test003ServiceImpl.save(test003));
  }

  /**
   * 修改-传入修改后的全部数据test003
   * @param test003 test003
   * @return XfR
   */
  @PutMapping("/test003s/{id}")
  public XfR putUpdate(@RequestBody Test003 test003,@PathVariable Long id) {
      test003.setId(id);
      return XfR.ok(test003ServiceImpl.updateById(test003));
  }

  /**
   * 修改-传入修改的数据test003
   * @param test003 test003
   * @return XfR
   */
  @PatchMapping("/test003s/{id}")
  public XfR patchUpdate(@RequestBody Test003 test003,@PathVariable Long id) {
      Test003 uptest003 = test003ServiceImpl.getById(id);
      if(uptest003 != null){
        uptest003 = ObjectCopyUtils.copyProperties(test003,uptest003,true);
      }
      return XfR.ok(test003ServiceImpl.updateById(uptest003));
  }

  /**
   * 通过id删除test003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test003ServiceImpl.removeById(id));
  }

  @PostMapping("/test003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test003");
     params.put("request", condition);

     return XfR.ok(test003ServiceImpl.querys(params));
  }

}
