package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.Detail002;
import com.xforceplus.ultraman.app.jcchenhuping.service.IDetail002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * detail002前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class Detail002Controller {

  @Autowired
  private IDetail002Service detail002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detail002 detail002
   * @return
   */
  @GetMapping("/detail002s" )
  public XfR getDetail002s(XfPage page, Detail002 detail002) {
    return XfR.ok(detail002ServiceImpl.page(page, Wrappers.query(detail002)));
  }

  /**
   * 通过id查询detail002
   * @param  id
   * @return XfR
   */
  @GetMapping("/detail002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detail002ServiceImpl.getById(id));
  }

  /**
   * 新增detail002
   * @param detail002 detail002
   * @return XfR
   */
  @PostMapping("/detail002s")
  public XfR save(@RequestBody Detail002 detail002) {
     return XfR.ok(detail002ServiceImpl.save(detail002));
  }

  /**
   * 修改-传入修改后的全部数据detail002
   * @param detail002 detail002
   * @return XfR
   */
  @PutMapping("/detail002s/{id}")
  public XfR putUpdate(@RequestBody Detail002 detail002,@PathVariable Long id) {
      detail002.setId(id);
      return XfR.ok(detail002ServiceImpl.updateById(detail002));
  }

  /**
   * 修改-传入修改的数据detail002
   * @param detail002 detail002
   * @return XfR
   */
  @PatchMapping("/detail002s/{id}")
  public XfR patchUpdate(@RequestBody Detail002 detail002,@PathVariable Long id) {
      Detail002 updetail002 = detail002ServiceImpl.getById(id);
      if(updetail002 != null){
        updetail002 = ObjectCopyUtils.copyProperties(detail002,updetail002,true);
      }
      return XfR.ok(detail002ServiceImpl.updateById(updetail002));
  }

  /**
   * 通过id删除detail002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/detail002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detail002ServiceImpl.removeById(id));
  }

  @PostMapping("/detail002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detail002");
     params.put("request", condition);

     return XfR.ok(detail002ServiceImpl.querys(params));
  }

}
