package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.FilterSalesInvoice;
import com.xforceplus.ultraman.app.jcchenhuping.service.IFilterSalesInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class FilterSalesInvoiceController {

  @Autowired
  private IFilterSalesInvoiceService filterSalesInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterSalesInvoice ${table.comment}
   * @return
   */
  @GetMapping("/filtersalesinvoices" )
  public XfR getFilterSalesInvoices(XfPage page, FilterSalesInvoice filterSalesInvoice) {
    return XfR.ok(filterSalesInvoiceServiceImpl.page(page, Wrappers.query(filterSalesInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filtersalesinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterSalesInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterSalesInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/filtersalesinvoices")
  public XfR save(@RequestBody FilterSalesInvoice filterSalesInvoice) {
     return XfR.ok(filterSalesInvoiceServiceImpl.save(filterSalesInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterSalesInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/filtersalesinvoices/{id}")
  public XfR putUpdate(@RequestBody FilterSalesInvoice filterSalesInvoice,@PathVariable Long id) {
      filterSalesInvoice.setId(id);
      return XfR.ok(filterSalesInvoiceServiceImpl.updateById(filterSalesInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterSalesInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filtersalesinvoices/{id}")
  public XfR patchUpdate(@RequestBody FilterSalesInvoice filterSalesInvoice,@PathVariable Long id) {
      FilterSalesInvoice upfilterSalesInvoice = filterSalesInvoiceServiceImpl.getById(id);
      if(upfilterSalesInvoice != null){
        upfilterSalesInvoice = ObjectCopyUtils.copyProperties(filterSalesInvoice,upfilterSalesInvoice,true);
      }
      return XfR.ok(filterSalesInvoiceServiceImpl.updateById(upfilterSalesInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filtersalesinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterSalesInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/filtersalesinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_sales_invoice");
     params.put("request", condition);

     return XfR.ok(filterSalesInvoiceServiceImpl.querys(params));
  }

}
