package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.GoodsInfo;
import com.xforceplus.ultraman.app.jcchenhuping.service.IGoodsInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 商品信息前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class GoodsInfoController {

  @Autowired
  private IGoodsInfoService goodsInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsInfo 商品信息
   * @return
   */
  @GetMapping("/goodsinfos" )
  public XfR getGoodsInfos(XfPage page, GoodsInfo goodsInfo) {
    return XfR.ok(goodsInfoServiceImpl.page(page, Wrappers.query(goodsInfo)));
  }

  /**
   * 通过id查询商品信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsInfoServiceImpl.getById(id));
  }

  /**
   * 新增商品信息
   * @param goodsInfo 商品信息
   * @return XfR
   */
  @PostMapping("/goodsinfos")
  public XfR save(@RequestBody GoodsInfo goodsInfo) {
     return XfR.ok(goodsInfoServiceImpl.save(goodsInfo));
  }

  /**
   * 修改-传入修改后的全部数据商品信息
   * @param goodsInfo 商品信息
   * @return XfR
   */
  @PutMapping("/goodsinfos/{id}")
  public XfR putUpdate(@RequestBody GoodsInfo goodsInfo,@PathVariable Long id) {
      goodsInfo.setId(id);
      return XfR.ok(goodsInfoServiceImpl.updateById(goodsInfo));
  }

  /**
   * 修改-传入修改的数据商品信息
   * @param goodsInfo 商品信息
   * @return XfR
   */
  @PatchMapping("/goodsinfos/{id}")
  public XfR patchUpdate(@RequestBody GoodsInfo goodsInfo,@PathVariable Long id) {
      GoodsInfo upgoodsInfo = goodsInfoServiceImpl.getById(id);
      if(upgoodsInfo != null){
        upgoodsInfo = ObjectCopyUtils.copyProperties(goodsInfo,upgoodsInfo,true);
      }
      return XfR.ok(goodsInfoServiceImpl.updateById(upgoodsInfo));
  }

  /**
   * 通过id删除商品信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsInfoServiceImpl.removeById(id));
  }

  @PostMapping("/goodsinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_info");
     params.put("request", condition);

     return XfR.ok(goodsInfoServiceImpl.querys(params));
  }

}
