package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.Test002oqs;
import com.xforceplus.ultraman.app.jcchenhuping.service.ITest002oqsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * test002oqs测试前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class Test002oqsController {

  @Autowired
  private ITest002oqsService test002oqsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test002oqs test002oqs测试
   * @return
   */
  @GetMapping("/test002oqss" )
  public XfR getTest002oqss(XfPage page, Test002oqs test002oqs) {
    return XfR.ok(test002oqsServiceImpl.page(page, Wrappers.query(test002oqs)));
  }

  /**
   * 通过id查询test002oqs测试
   * @param  id
   * @return XfR
   */
  @GetMapping("/test002oqss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test002oqsServiceImpl.getById(id));
  }

  /**
   * 新增test002oqs测试
   * @param test002oqs test002oqs测试
   * @return XfR
   */
  @PostMapping("/test002oqss")
  public XfR save(@RequestBody Test002oqs test002oqs) {
     return XfR.ok(test002oqsServiceImpl.save(test002oqs));
  }

  /**
   * 修改-传入修改后的全部数据test002oqs测试
   * @param test002oqs test002oqs测试
   * @return XfR
   */
  @PutMapping("/test002oqss/{id}")
  public XfR putUpdate(@RequestBody Test002oqs test002oqs,@PathVariable Long id) {
      test002oqs.setId(id);
      return XfR.ok(test002oqsServiceImpl.updateById(test002oqs));
  }

  /**
   * 修改-传入修改的数据test002oqs测试
   * @param test002oqs test002oqs测试
   * @return XfR
   */
  @PatchMapping("/test002oqss/{id}")
  public XfR patchUpdate(@RequestBody Test002oqs test002oqs,@PathVariable Long id) {
      Test002oqs uptest002oqs = test002oqsServiceImpl.getById(id);
      if(uptest002oqs != null){
        uptest002oqs = ObjectCopyUtils.copyProperties(test002oqs,uptest002oqs,true);
      }
      return XfR.ok(test002oqsServiceImpl.updateById(uptest002oqs));
  }

  /**
   * 通过id删除test002oqs测试
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test002oqss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test002oqsServiceImpl.removeById(id));
  }

  @PostMapping("/test002oqss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test002oqs");
     params.put("request", condition);

     return XfR.ok(test002oqsServiceImpl.querys(params));
  }

}
