package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.Detail001;
import com.xforceplus.ultraman.app.jcchenhuping.service.IDetail001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * detail001前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class Detail001Controller {

  @Autowired
  private IDetail001Service detail001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detail001 detail001
   * @return
   */
  @GetMapping("/detail001s" )
  public XfR getDetail001s(XfPage page, Detail001 detail001) {
    return XfR.ok(detail001ServiceImpl.page(page, Wrappers.query(detail001)));
  }

  /**
   * 通过id查询detail001
   * @param  id
   * @return XfR
   */
  @GetMapping("/detail001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detail001ServiceImpl.getById(id));
  }

  /**
   * 新增detail001
   * @param detail001 detail001
   * @return XfR
   */
  @PostMapping("/detail001s")
  public XfR save(@RequestBody Detail001 detail001) {
     return XfR.ok(detail001ServiceImpl.save(detail001));
  }

  /**
   * 修改-传入修改后的全部数据detail001
   * @param detail001 detail001
   * @return XfR
   */
  @PutMapping("/detail001s/{id}")
  public XfR putUpdate(@RequestBody Detail001 detail001,@PathVariable Long id) {
      detail001.setId(id);
      return XfR.ok(detail001ServiceImpl.updateById(detail001));
  }

  /**
   * 修改-传入修改的数据detail001
   * @param detail001 detail001
   * @return XfR
   */
  @PatchMapping("/detail001s/{id}")
  public XfR patchUpdate(@RequestBody Detail001 detail001,@PathVariable Long id) {
      Detail001 updetail001 = detail001ServiceImpl.getById(id);
      if(updetail001 != null){
        updetail001 = ObjectCopyUtils.copyProperties(detail001,updetail001,true);
      }
      return XfR.ok(detail001ServiceImpl.updateById(updetail001));
  }

  /**
   * 通过id删除detail001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/detail001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detail001ServiceImpl.removeById(id));
  }

  @PostMapping("/detail001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detail001");
     params.put("request", condition);

     return XfR.ok(detail001ServiceImpl.querys(params));
  }

}
