package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.DownPDF;
import com.xforceplus.ultraman.app.jcchenhuping.service.IDownPDFService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class DownPDFController {

  @Autowired
  private IDownPDFService downPDFServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param downPDF ${table.comment}
   * @return
   */
  @GetMapping("/downpdfs" )
  public XfR getDownPDFs(XfPage page, DownPDF downPDF) {
    return XfR.ok(downPDFServiceImpl.page(page, Wrappers.query(downPDF)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/downpdfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(downPDFServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param downPDF ${table.comment}
   * @return XfR
   */
  @PostMapping("/downpdfs")
  public XfR save(@RequestBody DownPDF downPDF) {
     return XfR.ok(downPDFServiceImpl.save(downPDF));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param downPDF ${table.comment}
   * @return XfR
   */
  @PutMapping("/downpdfs/{id}")
  public XfR putUpdate(@RequestBody DownPDF downPDF,@PathVariable Long id) {
      downPDF.setId(id);
      return XfR.ok(downPDFServiceImpl.updateById(downPDF));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param downPDF ${table.comment}
   * @return XfR
   */
  @PatchMapping("/downpdfs/{id}")
  public XfR patchUpdate(@RequestBody DownPDF downPDF,@PathVariable Long id) {
      DownPDF updownPDF = downPDFServiceImpl.getById(id);
      if(updownPDF != null){
        updownPDF = ObjectCopyUtils.copyProperties(downPDF,updownPDF,true);
      }
      return XfR.ok(downPDFServiceImpl.updateById(updownPDF));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/downpdfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(downPDFServiceImpl.removeById(id));
  }

  @PostMapping("/downpdfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "down_p_d_f");
     params.put("request", condition);

     return XfR.ok(downPDFServiceImpl.querys(params));
  }

}
