package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.ExtendCode;
import com.xforceplus.ultraman.app.jcchenhuping.service.IExtendCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * extendCode前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class ExtendCodeController {

  @Autowired
  private IExtendCodeService extendCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extendCode extendCode
   * @return
   */
  @GetMapping("/extendcodes" )
  public XfR getExtendCodes(XfPage page, ExtendCode extendCode) {
    return XfR.ok(extendCodeServiceImpl.page(page, Wrappers.query(extendCode)));
  }

  /**
   * 通过id查询extendCode
   * @param  id
   * @return XfR
   */
  @GetMapping("/extendcodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extendCodeServiceImpl.getById(id));
  }

  /**
   * 新增extendCode
   * @param extendCode extendCode
   * @return XfR
   */
  @PostMapping("/extendcodes")
  public XfR save(@RequestBody ExtendCode extendCode) {
     return XfR.ok(extendCodeServiceImpl.save(extendCode));
  }

  /**
   * 修改-传入修改后的全部数据extendCode
   * @param extendCode extendCode
   * @return XfR
   */
  @PutMapping("/extendcodes/{id}")
  public XfR putUpdate(@RequestBody ExtendCode extendCode,@PathVariable Long id) {
      extendCode.setId(id);
      return XfR.ok(extendCodeServiceImpl.updateById(extendCode));
  }

  /**
   * 修改-传入修改的数据extendCode
   * @param extendCode extendCode
   * @return XfR
   */
  @PatchMapping("/extendcodes/{id}")
  public XfR patchUpdate(@RequestBody ExtendCode extendCode,@PathVariable Long id) {
      ExtendCode upextendCode = extendCodeServiceImpl.getById(id);
      if(upextendCode != null){
        upextendCode = ObjectCopyUtils.copyProperties(extendCode,upextendCode,true);
      }
      return XfR.ok(extendCodeServiceImpl.updateById(upextendCode));
  }

  /**
   * 通过id删除extendCode
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extendcodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extendCodeServiceImpl.removeById(id));
  }

  @PostMapping("/extendcodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "extend_code");
     params.put("request", condition);

     return XfR.ok(extendCodeServiceImpl.querys(params));
  }

}
