package com.xforceplus.ultraman.app.jcchenhuping.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcchenhuping.entity.Title;
import com.xforceplus.ultraman.app.jcchenhuping.service.ITitleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * title前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class TitleController {

  @Autowired
  private ITitleService titleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param title title
   * @return
   */
  @GetMapping("/titles" )
  public XfR getTitles(XfPage page, Title title) {
    return XfR.ok(titleServiceImpl.page(page, Wrappers.query(title)));
  }

  /**
   * 通过id查询title
   * @param  id
   * @return XfR
   */
  @GetMapping("/titles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(titleServiceImpl.getById(id));
  }

  /**
   * 新增title
   * @param title title
   * @return XfR
   */
  @PostMapping("/titles")
  public XfR save(@RequestBody Title title) {
     return XfR.ok(titleServiceImpl.save(title));
  }

  /**
   * 修改-传入修改后的全部数据title
   * @param title title
   * @return XfR
   */
  @PutMapping("/titles/{id}")
  public XfR putUpdate(@RequestBody Title title,@PathVariable Long id) {
      title.setId(id);
      return XfR.ok(titleServiceImpl.updateById(title));
  }

  /**
   * 修改-传入修改的数据title
   * @param title title
   * @return XfR
   */
  @PatchMapping("/titles/{id}")
  public XfR patchUpdate(@RequestBody Title title,@PathVariable Long id) {
      Title uptitle = titleServiceImpl.getById(id);
      if(uptitle != null){
        uptitle = ObjectCopyUtils.copyProperties(title,uptitle,true);
      }
      return XfR.ok(titleServiceImpl.updateById(uptitle));
  }

  /**
   * 通过id删除title
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/titles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(titleServiceImpl.removeById(id));
  }

  @PostMapping("/titles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "title");
     params.put("request", condition);

     return XfR.ok(titleServiceImpl.querys(params));
  }

}
