package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 折扣规则配置表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.DiscountRuleConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface DiscountRuleConfigFeignApi {

  /**
   * 通过id查询折扣规则配置表
   * @param  id
   * @return R
   */
  @GetMapping("/discountRuleConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增折扣规则配置表
   * @param discountRuleConfig 折扣规则配置表
   * @return R
   */
  @PostMapping("/discountRuleConfig/add")
  public R save(@RequestBody DiscountRuleConfig discountRuleConfig);

  /**
   * 修改折扣规则配置表
   * @param discountRuleConfig 折扣规则配置表
   * @return R
   */
  @PostMapping("/discountRuleConfig/update")
  public R updateById(@RequestBody DiscountRuleConfig discountRuleConfig);

  /**
   * 通过id删除折扣规则配置表
   * @param  id
   * @return R
   */
  @DeleteMapping("/discountRuleConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}