package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 业务错误日志feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.ExpectionLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface ExpectionLogFeignApi {

  /**
   * 通过id查询业务错误日志
   * @param  id
   * @return R
   */
  @GetMapping("/expectionLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务错误日志
   * @param expectionLog 业务错误日志
   * @return R
   */
  @PostMapping("/expectionLog/add")
  public R save(@RequestBody ExpectionLog expectionLog);

  /**
   * 修改业务错误日志
   * @param expectionLog 业务错误日志
   * @return R
   */
  @PostMapping("/expectionLog/update")
  public R updateById(@RequestBody ExpectionLog expectionLog);

  /**
   * 通过id删除业务错误日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/expectionLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}