package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 发票明细表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.InvoiceDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface InvoiceDetailsFeignApi {

  /**
   * 通过id查询发票明细表
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票明细表
   * @param invoiceDetails 发票明细表
   * @return R
   */
  @PostMapping("/invoiceDetails/add")
  public R save(@RequestBody InvoiceDetails invoiceDetails);

  /**
   * 修改发票明细表
   * @param invoiceDetails 发票明细表
   * @return R
   */
  @PostMapping("/invoiceDetails/update")
  public R updateById(@RequestBody InvoiceDetails invoiceDetails);

  /**
   * 通过id删除发票明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}