package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 主商品配置表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.ProductCodeConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface ProductCodeConfigFeignApi {

  /**
   * 通过id查询主商品配置表
   * @param  id
   * @return R
   */
  @GetMapping("/productCodeConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增主商品配置表
   * @param productCodeConfig 主商品配置表
   * @return R
   */
  @PostMapping("/productCodeConfig/add")
  public R save(@RequestBody ProductCodeConfig productCodeConfig);

  /**
   * 修改主商品配置表
   * @param productCodeConfig 主商品配置表
   * @return R
   */
  @PostMapping("/productCodeConfig/update")
  public R updateById(@RequestBody ProductCodeConfig productCodeConfig);

  /**
   * 通过id删除主商品配置表
   * @param  id
   * @return R
   */
  @DeleteMapping("/productCodeConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}