package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 商品名称关键字表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.ProductNameKeyword;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface ProductNameKeywordFeignApi {

  /**
   * 通过id查询商品名称关键字表
   * @param  id
   * @return R
   */
  @GetMapping("/productNameKeyword/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商品名称关键字表
   * @param productNameKeyword 商品名称关键字表
   * @return R
   */
  @PostMapping("/productNameKeyword/add")
  public R save(@RequestBody ProductNameKeyword productNameKeyword);

  /**
   * 修改商品名称关键字表
   * @param productNameKeyword 商品名称关键字表
   * @return R
   */
  @PostMapping("/productNameKeyword/update")
  public R updateById(@RequestBody ProductNameKeyword productNameKeyword);

  /**
   * 通过id删除商品名称关键字表
   * @param  id
   * @return R
   */
  @DeleteMapping("/productNameKeyword/del/{id}" )
  public R removeById(@PathVariable Long id);

}