package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 明细行数记录表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.SalesBillDetailCount;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface SalesBillDetailCountFeignApi {

  /**
   * 通过id查询明细行数记录表
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillDetailCount/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增明细行数记录表
   * @param salesBillDetailCount 明细行数记录表
   * @return R
   */
  @PostMapping("/salesBillDetailCount/add")
  public R save(@RequestBody SalesBillDetailCount salesBillDetailCount);

  /**
   * 修改明细行数记录表
   * @param salesBillDetailCount 明细行数记录表
   * @return R
   */
  @PostMapping("/salesBillDetailCount/update")
  public R updateById(@RequestBody SalesBillDetailCount salesBillDetailCount);

  /**
   * 通过id删除明细行数记录表
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillDetailCount/del/{id}" )
  public R removeById(@PathVariable Long id);

}