package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 业务单明细表feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.SalesBillDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface SalesBillDetailsFeignApi {

  /**
   * 通过id查询业务单明细表
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单明细表
   * @param salesBillDetails 业务单明细表
   * @return R
   */
  @PostMapping("/salesBillDetails/add")
  public R save(@RequestBody SalesBillDetails salesBillDetails);

  /**
   * 修改业务单明细表
   * @param salesBillDetails 业务单明细表
   * @return R
   */
  @PostMapping("/salesBillDetails/update")
  public R updateById(@RequestBody SalesBillDetails salesBillDetails);

  /**
   * 通过id删除业务单明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}