package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 业务单履历feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.SalesBillRecord;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface SalesBillRecordFeignApi {

  /**
   * 通过id查询业务单履历
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillRecord/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单履历
   * @param salesBillRecord 业务单履历
   * @return R
   */
  @PostMapping("/salesBillRecord/add")
  public R save(@RequestBody SalesBillRecord salesBillRecord);

  /**
   * 修改业务单履历
   * @param salesBillRecord 业务单履历
   * @return R
   */
  @PostMapping("/salesBillRecord/update")
  public R updateById(@RequestBody SalesBillRecord salesBillRecord);

  /**
   * 通过id删除业务单履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillRecord/del/{id}" )
  public R removeById(@PathVariable Long id);

}