package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 已扫描的Dat文件feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.ScannedDat;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface ScannedDatFeignApi {

  /**
   * 通过id查询已扫描的Dat文件
   * @param  id
   * @return R
   */
  @GetMapping("/scannedDat/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增已扫描的Dat文件
   * @param scannedDat 已扫描的Dat文件
   * @return R
   */
  @PostMapping("/scannedDat/add")
  public R save(@RequestBody ScannedDat scannedDat);

  /**
   * 修改已扫描的Dat文件
   * @param scannedDat 已扫描的Dat文件
   * @return R
   */
  @PostMapping("/scannedDat/update")
  public R updateById(@RequestBody ScannedDat scannedDat);

  /**
   * 通过id删除已扫描的Dat文件
   * @param  id
   * @return R
   */
  @DeleteMapping("/scannedDat/del/{id}" )
  public R removeById(@PathVariable Long id);

}