package com.xforceplus.ultraman.app.jccolgate.controller;


/**
 * 定时任务执行日志feign客户端
 *
 * @author ultraman
 * @date 2021-11-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccolgate.entity.TaskLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface TaskLogFeignApi {

  /**
   * 通过id查询定时任务执行日志
   * @param  id
   * @return R
   */
  @GetMapping("/taskLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增定时任务执行日志
   * @param taskLog 定时任务执行日志
   * @return R
   */
  @PostMapping("/taskLog/add")
  public R save(@RequestBody TaskLog taskLog);

  /**
   * 修改定时任务执行日志
   * @param taskLog 定时任务执行日志
   * @return R
   */
  @PostMapping("/taskLog/update")
  public R updateById(@RequestBody TaskLog taskLog);

  /**
   * 通过id删除定时任务执行日志
   * @param  id
   * @return R
   */
  @DeleteMapping("/taskLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}