package com.xforceplus.ultraman.app.jccolgate.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-09-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceDetails implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("invoiceCode")
  private String invoiceCode;

  @TableField("cargoName")
  private String cargoName;

  @TableField("itemSpec")
  private String itemSpec;

  @TableField("quantityUnit")
  private String quantityUnit;

  private BigDecimal quantity;

  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  @TableField("taxRate")
  private BigDecimal taxRate;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  @TableField("unitPrice")
  private BigDecimal unitPrice;

  @TableField("taxAmount")
  private BigDecimal taxAmount;

  @TableField("salesbillItemNo")
  private String salesbillItemNo;

  private BigDecimal deduction;

  @TableField("taxPreCon")
  private String taxPreCon;

  @TableField("taxPre")
  private String taxPre;

  @TableField("zeroTax")
  private String zeroTax;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("salesbillNo")
  private String salesbillNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("cargoName", cargoName);
      map.put("itemSpec", itemSpec);
      map.put("quantityUnit", quantityUnit);
      map.put("quantity", quantity);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("taxRate", taxRate);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("unitPrice", unitPrice);
      map.put("taxAmount", taxAmount);
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("deduction", deduction);
      map.put("taxPreCon", taxPreCon);
      map.put("taxPre", taxPre);
      map.put("zeroTax", zeroTax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesbillNo", salesbillNo);
      return map;
  }

  public static InvoiceDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceDetails entity = new InvoiceDetails();
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargoName")) {
      Object obj = map.get("cargoName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
