package com.xforceplus.ultraman.app.jccolgate.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 折扣规则枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-09-28
 */
public enum DiscountRuleEnum {

    _1("1", "价内折扣"),
    _2("2", "价外折扣");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DiscountRuleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiscountRuleEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
