package com.xforceplus.ultraman.app.jccolgate.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-09-28
 */
public enum SalesBillStatusEnum {

    _0("0", "已作废"),
    _1("1", "待反馈"),
    _9("9", "已删除"),
    __1("-1", "上传失败"),
    _10("10", "待上传"),
    _11("11", "待计算"),
    _12("12", "上传成功"),
    _13("13", "已开票"),
    _14("14", "计算失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesBillStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "9":
                return _9;
            case "-1":
                return __1;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            default:
                return null;
        }
    }
}
