package com.xforceplus.ultraman.app.jccolgate.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 操作类型
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
public enum OperationTypeEnum {

    _0("0", "读取文件"),
    _1("1", "转换源数据"),
    _2("2", "金额计算"),
    _3("3", "上传业务单"),
    _4("4", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationTypeEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
