package com.xforceplus.ultraman.app.jccolgate.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * discount_rule_config
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DiscountRuleConfig implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 销售折扣规则
   */
  private String salesDiscount;
  /**
   * 是否有效
   */
  private String status;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 发票金额类型
   */
  private String invoiceAmountType;
  /**
   * 客户号
   */
  private String purchaserNo;
  /**
   * 数量折扣规则
   */
  private String quantityDiscount;
  /**
   * 现金折扣
   */
  private String cashDiscount;
  /**
   * 配送折扣
   */
  private String logisticDiscount;
  /**
   * 固定折扣
   */
  private String fixedDiscount;
  /**
   * 质量管理折扣
   */
  private String marketHygiene;
  /**
   * 信息共享折扣
   */
  private String infoSharing;
  /**
   * 进货数量折扣
   */
  private String volumeDisc;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesDiscount", salesDiscount);
      map.put("status", status);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceAmountType", invoiceAmountType);
      map.put("purchaserNo", purchaserNo);
      map.put("quantityDiscount", quantityDiscount);
      map.put("cashDiscount", cashDiscount);
      map.put("logisticDiscount", logisticDiscount);
      map.put("fixedDiscount", fixedDiscount);
      map.put("marketHygiene", marketHygiene);
      map.put("infoSharing", infoSharing);
      map.put("volumeDisc", volumeDisc);

      return map;
  }

  public static DiscountRuleConfig fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DiscountRuleConfig entity = new DiscountRuleConfig();

    if(map.containsKey("salesDiscount")) {
      Object obj = map.get("salesDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmountType")) {
      Object obj = map.get("invoiceAmountType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceAmountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityDiscount")) {
      Object obj = map.get("quantityDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashDiscount")) {
      Object obj = map.get("cashDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticDiscount")) {
      Object obj = map.get("logisticDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fixedDiscount")) {
      Object obj = map.get("fixedDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFixedDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("marketHygiene")) {
      Object obj = map.get("marketHygiene");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMarketHygiene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("infoSharing")) {
      Object obj = map.get("infoSharing");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInfoSharing((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeDisc")) {
      Object obj = map.get("volumeDisc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeDisc((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("salesDiscount")) {
      Object obj = map.get("salesDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceAmountType")) {
      Object obj = map.get("invoiceAmountType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceAmountType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantityDiscount")) {
      Object obj = map.get("quantityDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cashDiscount")) {
      Object obj = map.get("cashDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setCashDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("logisticDiscount")) {
      Object obj = map.get("logisticDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setLogisticDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("fixedDiscount")) {
      Object obj = map.get("fixedDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setFixedDiscount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("marketHygiene")) {
      Object obj = map.get("marketHygiene");
      if(obj != null) {
        if(obj instanceof String){
            this.setMarketHygiene((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("infoSharing")) {
      Object obj = map.get("infoSharing");
      if(obj != null) {
        if(obj instanceof String){
            this.setInfoSharing((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("volumeDisc")) {
      Object obj = map.get("volumeDisc");
      if(obj != null) {
        if(obj instanceof String){
            this.setVolumeDisc((String)obj);
        }
      } else{
      }
   }

  }

}
