package com.xforceplus.ultraman.app.jccolgate.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_main
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 开票日期
   */
  private Long paperDrewDate;
  /**
   * 备注
   */
  private String remark;
  /**
   * 收款人姓名
   */
  private String cashierName;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 系统来源
   */
  private String systemOrig;
  /**
   * 电票PDF地址
   */
  private String pdfPath;
  /**
   * 邮箱
   */
  private String receiveUserEmail;
  /**
   * 购方银行名称
   */
  private String purchaserBankNameAccount;
  /**
   * 勾选状态
   */
  private String authStatus;
  /**
   * 红冲状态
   */
  private String redStatus;
  /**
   * 红冲时间
   */
  private String redTime;
  /**
   * 红冲人姓名
   */
  private String redUserName;
  /**
   * 退票状态
   */
  private String retreatStatus;
  /**
   * 退票操作时间
   */
  private String retreatTime;
  /**
   * 查验状态
   */
  private String veriStatus;
  /**
   * 查验人
   */
  private String veriUserName;
  /**
   * 冻结状态
   */
  private String freezeStatus;
  /**
   * 冻结操作时间
   */
  private String freezeTime;
  /**
   * 冻结操作人姓名
   */
  private String freezeUserName;
  /**
   * 是否已收票扫描
   */
  private String receiveInvoice;
  /**
   * 发票号
   */
  private String ext1;
  /**
   * 系统发票号
   */
  private String ext2;
  /**
   * 拓展字段3
   */
  private String ext3;
  /**
   * 进项下发结果
   */
  private String pmsg;
  /**
   * 发票来源 0-默认 11-销方直连 12-销方抽取 13-销方手工回填 21-国税验真 22-国税底账 31-影像识别
   */
  private String invoiceOrig;
  /**
   * 销方公司
   */
  private String sellerName;
  /**
   * 识别状态
   */
  private String recogStatus;
  /**
   * PDF地址
   */
  private String pdfUrl;
  /**
   * 业务单号
   */
  private String bussinessNo;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 业务单号
   */
  private String salesbillNo;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceType", invoiceType);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("paperDrewDate", paperDrewDate);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("status", status);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("cipherText", cipherText);
      map.put("systemOrig", systemOrig);
      map.put("pdfPath", pdfPath);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("purchaserBankNameAccount", purchaserBankNameAccount);
      map.put("authStatus", authStatus);
      map.put("redStatus", redStatus);
      map.put("redTime", redTime);
      map.put("redUserName", redUserName);
      map.put("retreatStatus", retreatStatus);
      map.put("retreatTime", retreatTime);
      map.put("veriStatus", veriStatus);
      map.put("veriUserName", veriUserName);
      map.put("freezeStatus", freezeStatus);
      map.put("freezeTime", freezeTime);
      map.put("freezeUserName", freezeUserName);
      map.put("receiveInvoice", receiveInvoice);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("pmsg", pmsg);
      map.put("invoiceOrig", invoiceOrig);
      map.put("sellerName", sellerName);
      map.put("recogStatus", recogStatus);
      map.put("pdfUrl", pdfUrl);
      map.put("bussinessNo", bussinessNo);
      map.put("checkCode", checkCode);
      map.put("purchaserNo", purchaserNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesbillNo", salesbillNo);

      return map;
  }

  public static InvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMain entity = new InvoiceMain();

    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate((Long)obj);
        } else if(obj instanceof String) {
          entity.setPaperDrewDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaperDrewDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVeriUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeTime")) {
      Object obj = map.get("freezeTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeUserName")) {
      Object obj = map.get("freezeUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreezeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveInvoice")) {
      Object obj = map.get("receiveInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pmsg")) {
      Object obj = map.get("pmsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPmsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBussinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrewDate((Long)obj);
        } else if(obj instanceof String) {
            this.setPaperDrewDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPaperDrewDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCashierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
            this.setStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
            this.setCipherText((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String){
            this.setPdfPath((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceiveUserEmail((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setRedStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String){
            this.setRedTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setRedUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setVeriStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setVeriUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setFreezeStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("freezeTime")) {
      Object obj = map.get("freezeTime");
      if(obj != null) {
        if(obj instanceof String){
            this.setFreezeTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("freezeUserName")) {
      Object obj = map.get("freezeUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setFreezeUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("receiveInvoice")) {
      Object obj = map.get("receiveInvoice");
      if(obj != null) {
        if(obj instanceof String){
            this.setReceiveInvoice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt1((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt2((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
            this.setExt3((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pmsg")) {
      Object obj = map.get("pmsg");
      if(obj != null) {
        if(obj instanceof String){
            this.setPmsg((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setRecogStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String){
            this.setPdfUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBussinessNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
   }

  }

}
