package com.xforceplus.ultraman.app.jccolgate.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * sales_bill_details
 * </p>
 *
 * @author ultraman
 * @since 2021-11-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesBillDetails implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 明细编号
   */
  private String salesbillItemNo;
  /**
   * 货物或应税劳务名称 
   */
  private String itemName;
  /**
   * 规格型号
   */
  private String itemSpec;
  /**
   * 数量单位
   */
  private String quantityUnit;
  /**
   * 不含税单价
   */
  private BigDecimal unitPrice;
  /**
   * 扣除额
   */
  private BigDecimal deduction;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 税收分类转换代码
   */
  private String taxConvertCode;
  /**
   * 是否享受税收优惠政策
   */
  private String taxPre;
  /**
   * 税收优惠
   */
  private String taxPreCon;
  /**
   * 零税率标志
   */
  private String zeroTax;
  /**
   * 数量折扣
   */
  private BigDecimal ext1;
  /**
   * 销售折扣
   */
  private BigDecimal ext2;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 业务单号
   */
  private String salesbillNo;
  /**
   * 现金折扣
   */
  private BigDecimal ext3;
  /**
   * 配送折扣
   */
  private BigDecimal ext4;
  /**
   * 固定折扣
   */
  private BigDecimal ext5;
  /**
   * 质量管理折扣
   */
  private BigDecimal ext6;
  /**
   * 信息共享折扣
   */
  private BigDecimal ext7;
  /**
   * 进货数量折扣
   */
  private BigDecimal ext8;
  /**
   * 折扣率
   */
  private BigDecimal discount;
  /**
   * 不含税折扣金额
   */
  private BigDecimal ext9;
  /**
   * 折扣税额
   */
  private BigDecimal ext10;
  /**
   * 价外含税折扣
   */
  private BigDecimal outterDiscountWithTax;
  /**
   * 价外不含税折扣
   */
  private BigDecimal outterDiscountWithoutTax;
  /**
   * 价外折扣税额
   */
  private BigDecimal outterDiscountTax;
  /**
   * 价内含税折扣
   */
  private BigDecimal innerDiscountWithTax;
  /**
   * 价内不含税折扣
   */
  private BigDecimal innerDiscountWithoutTax;
  /**
   * 价内折扣税额
   */
  private BigDecimal innerDiscountTax;

  /**
   * 对多关联关系 关联对象 salesBillMain
   */
  private Long salesBillId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillItemNo", salesbillItemNo);
      map.put("itemName", itemName);
      map.put("itemSpec", itemSpec);
      map.put("quantityUnit", quantityUnit);
      map.put("unitPrice", unitPrice);
      map.put("deduction", deduction);
      map.put("quantity", quantity);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxRate", taxRate);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("taxConvertCode", taxConvertCode);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("salesbillNo", salesbillNo);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("discount", discount);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("innerDiscountTax", innerDiscountTax);

      map.put("salesBill.id", salesBillId);
      return map;
  }

  public static SalesBillDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesBillDetails entity = new SalesBillDetails();

    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt2((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt4((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt4(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt4(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt4(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt4(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt5((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt5(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt5(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt5(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt5(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt7((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt8((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt9((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt9(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt9(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt9(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt9(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExt10((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExt10(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExt10(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExt10(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExt10(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    if(map.containsKey("salesBill.id")) {
       entity.setSalesBillId((Long)map.get("salesBill.id" ));
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("salesbillItemNo")) {
      Object obj = map.get("salesbillItemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillItemNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("itemSpec")) {
      Object obj = map.get("itemSpec");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemSpec((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDeduction((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDeduction(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDeduction(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDeduction(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDeduction(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxConvertCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPre((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPreCon((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setZeroTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt1((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt2((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt3((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt4((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt4(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt4(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt4(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt4(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt5((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt5(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt5(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt5(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt5(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt6((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt7((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt8((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt9((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt9(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt9(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt9(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt9(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setExt10((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setExt10(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setExt10(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setExt10(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setExt10(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }

  if(map.containsKey("salesBill.id")) {
    this.setSalesBillId((Long)map.get("salesBill.id" ));
  }
  }

}
