package com.xforceplus.ultraman.app.jccolgate.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* 对象元数据
*
* @author ultraman
* @since 2021-11-01
*/
public class EntityMeta {

    public interface InvoiceMain {
        static Long id() {
            return 1408335260447838209L;
        }
        static String code() {
            return "invoiceMain";
        }
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerAddrTel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<Long> PAPER_DREW_DATE = new TypedField<>(Long.class, "paperDrewDate");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "redNotificationNo");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipherText");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "systemOrig");
        TypedField<String> PDF_PATH = new TypedField<>(String.class, "pdfPath");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receiveUserEmail");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaserBankNameAccount");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> RED_STATUS = new TypedField<>(String.class, "redStatus");
        TypedField<String> RED_TIME = new TypedField<>(String.class, "redTime");
        TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "redUserName");
        TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "retreatStatus");
        TypedField<String> RETREAT_TIME = new TypedField<>(String.class, "retreatTime");
        TypedField<String> VERI_STATUS = new TypedField<>(String.class, "veriStatus");
        TypedField<String> VERI_USER_NAME = new TypedField<>(String.class, "veriUserName");
        TypedField<String> FREEZE_STATUS = new TypedField<>(String.class, "freezeStatus");
        TypedField<String> FREEZE_TIME = new TypedField<>(String.class, "freezeTime");
        TypedField<String> FREEZE_USER_NAME = new TypedField<>(String.class, "freezeUserName");
        TypedField<String> RECEIVE_INVOICE = new TypedField<>(String.class, "receiveInvoice");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> PMSG = new TypedField<>(String.class, "pmsg");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceOrig");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recogStatus");
        TypedField<String> PDF_URL = new TypedField<>(String.class, "pdfUrl");
        TypedField<String> BUSSINESS_NO = new TypedField<>(String.class, "bussinessNo");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "checkCode");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");

        interface ToOneRel {
        }
    }
    public interface InvoiceDetails {
        static Long id() {
            return 1408335450517217282L;
        }
        static String code() {
            return "invoiceDetails";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargoName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        /**
         * 对多关联关系 关联对象 invoiceMain
         */
        TypedField<Long> SELLERINVOICE_ID = new TypedField<>(Long.class, "sellerInvoice.id");

        interface ToOneRel {
            interface SELLERINVOICE {
                static String code () {
                    return "sellerInvoice" ;
                }
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "sellerInvoice.invoiceType");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "sellerInvoice.invoiceNo");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "sellerInvoice.invoiceCode");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerInvoice.sellerNo");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerInvoice.sellerTaxNo");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "sellerInvoice.sellerAddrTel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerInvoice.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerInvoice.sellerTel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerInvoice.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerInvoice.sellerBankAccount");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "sellerInvoice.purchaserTaxNo");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "sellerInvoice.purchaserName");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "sellerInvoice.purchaserAddress");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "sellerInvoice.purchaserTel");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "sellerInvoice.purchaserBankName");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerInvoice.purchaserBankAccount");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "sellerInvoice.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "sellerInvoice.taxAmount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "sellerInvoice.amountWithTax");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "sellerInvoice.taxRate");
                TypedField<Long> PAPER_DREW_DATE = new TypedField<>(Long.class, "sellerInvoice.paperDrewDate");
                TypedField<String> REMARK = new TypedField<>(String.class, "sellerInvoice.remark");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "sellerInvoice.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "sellerInvoice.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "sellerInvoice.invoicerName");
                TypedField<String> STATUS = new TypedField<>(String.class, "sellerInvoice.status");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "sellerInvoice.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "sellerInvoice.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "sellerInvoice.redNotificationNo");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "sellerInvoice.cipherText");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "sellerInvoice.systemOrig");
                TypedField<String> PDF_PATH = new TypedField<>(String.class, "sellerInvoice.pdfPath");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "sellerInvoice.receiveUserEmail");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "sellerInvoice.purchaserBankNameAccount");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "sellerInvoice.authStatus");
                TypedField<String> RED_STATUS = new TypedField<>(String.class, "sellerInvoice.redStatus");
                TypedField<String> RED_TIME = new TypedField<>(String.class, "sellerInvoice.redTime");
                TypedField<String> RED_USER_NAME = new TypedField<>(String.class, "sellerInvoice.redUserName");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "sellerInvoice.retreatStatus");
                TypedField<String> RETREAT_TIME = new TypedField<>(String.class, "sellerInvoice.retreatTime");
                TypedField<String> VERI_STATUS = new TypedField<>(String.class, "sellerInvoice.veriStatus");
                TypedField<String> VERI_USER_NAME = new TypedField<>(String.class, "sellerInvoice.veriUserName");
                TypedField<String> FREEZE_STATUS = new TypedField<>(String.class, "sellerInvoice.freezeStatus");
                TypedField<String> FREEZE_TIME = new TypedField<>(String.class, "sellerInvoice.freezeTime");
                TypedField<String> FREEZE_USER_NAME = new TypedField<>(String.class, "sellerInvoice.freezeUserName");
                TypedField<String> RECEIVE_INVOICE = new TypedField<>(String.class, "sellerInvoice.receiveInvoice");
                TypedField<String> EXT1 = new TypedField<>(String.class, "sellerInvoice.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "sellerInvoice.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "sellerInvoice.ext3");
                TypedField<String> PMSG = new TypedField<>(String.class, "sellerInvoice.pmsg");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "sellerInvoice.invoiceOrig");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerInvoice.sellerName");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "sellerInvoice.recogStatus");
                TypedField<String> PDF_URL = new TypedField<>(String.class, "sellerInvoice.pdfUrl");
                TypedField<String> BUSSINESS_NO = new TypedField<>(String.class, "sellerInvoice.bussinessNo");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "sellerInvoice.checkCode");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "sellerInvoice.purchaserNo");
                TypedField<Long> ID = new TypedField<>(Long.class, "sellerInvoice.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "sellerInvoice.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "sellerInvoice.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "sellerInvoice.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "sellerInvoice.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "sellerInvoice.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "sellerInvoice.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "sellerInvoice.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "sellerInvoice.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "sellerInvoice.delete_flag");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "sellerInvoice.salesbillNo");
            }
        }
    }
    public interface SalesBillMain {
        static Long id() {
            return 1408335634915598337L;
        }
        static String code() {
            return "salesBillMain";
        }
        TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "businessBillType");
        TypedField<String> TERMINAL_CODE = new TypedField<>(String.class, "terminalCode");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "systemOrig");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "priceMethod");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicerName");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receiveUserEmail");
        TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "salesbillType");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> RED_NOTIFICATION = new TypedField<>(String.class, "redNotification");
        TypedField<String> PROCESS_STATUS = new TypedField<>(String.class, "processStatus");
        TypedField<String> PROCESS_RESULT = new TypedField<>(String.class, "processResult");
        TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "processRemark");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaserAddress");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaserBankAccount");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaserBankName");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaserBankNameAccount");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaserTel");
        TypedField<String> SYS_ORG_CODE = new TypedField<>(String.class, "sysOrgCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> UPLOAD_COUNT = new TypedField<>(Long.class, "uploadCount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<String> SOURCE_SALES_BILL_NO = new TypedField<>(String.class, "sourceSalesBillNo");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");

        interface ToOneRel {
        }
    }
    public interface SalesBillDetails {
        static Long id() {
            return 1408335752049627137L;
        }
        static String code() {
            return "salesBillDetails";
        }
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbillItemNo");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "itemSpec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantityUnit");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unitPrice");
        TypedField<BigDecimal> DEDUCTION = new TypedField<>(BigDecimal.class, "deduction");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amountWithoutTax");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "taxRate");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "taxAmount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amountWithTax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "taxConvertCode");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<BigDecimal> EXT1 = new TypedField<>(BigDecimal.class, "ext1");
        TypedField<BigDecimal> EXT2 = new TypedField<>(BigDecimal.class, "ext2");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<BigDecimal> EXT3 = new TypedField<>(BigDecimal.class, "ext3");
        TypedField<BigDecimal> EXT4 = new TypedField<>(BigDecimal.class, "ext4");
        TypedField<BigDecimal> EXT5 = new TypedField<>(BigDecimal.class, "ext5");
        TypedField<BigDecimal> EXT6 = new TypedField<>(BigDecimal.class, "ext6");
        TypedField<BigDecimal> EXT7 = new TypedField<>(BigDecimal.class, "ext7");
        TypedField<BigDecimal> EXT8 = new TypedField<>(BigDecimal.class, "ext8");
        TypedField<BigDecimal> DISCOUNT = new TypedField<>(BigDecimal.class, "discount");
        TypedField<BigDecimal> EXT9 = new TypedField<>(BigDecimal.class, "ext9");
        TypedField<BigDecimal> EXT10 = new TypedField<>(BigDecimal.class, "ext10");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outterDiscountWithoutTax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "outterDiscountTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithTax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "innerDiscountWithoutTax");
        TypedField<BigDecimal> INNER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "innerDiscountTax");
        /**
         * 对多关联关系 关联对象 salesBillMain
         */
        TypedField<Long> SALESBILL_ID = new TypedField<>(Long.class, "salesBill.id");

        interface ToOneRel {
            interface SALESBILL {
                static String code () {
                    return "salesBill" ;
                }
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "salesBill.businessBillType");
                TypedField<String> TERMINAL_CODE = new TypedField<>(String.class, "salesBill.terminalCode");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "salesBill.systemOrig");
                TypedField<String> STATUS = new TypedField<>(String.class, "salesBill.status");
                TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesBill.salesbillNo");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "salesBill.amountWithTax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "salesBill.amountWithoutTax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "salesBill.taxAmount");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "salesBill.invoiceType");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "salesBill.priceMethod");
                TypedField<String> REMARK = new TypedField<>(String.class, "salesBill.remark");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "salesBill.sellerTaxNo");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "salesBill.sellerName");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "salesBill.sellerAddress");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "salesBill.sellerTel");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "salesBill.sellerBankName");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "salesBill.sellerBankAccount");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "salesBill.purchaserNo");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "salesBill.cashierName");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "salesBill.checkerName");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "salesBill.invoicerName");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "salesBill.receiveUserEmail");
                TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "salesBill.salesbillType");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "salesBill.originInvoiceNo");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "salesBill.originInvoiceCode");
                TypedField<String> RED_NOTIFICATION = new TypedField<>(String.class, "salesBill.redNotification");
                TypedField<String> PROCESS_STATUS = new TypedField<>(String.class, "salesBill.processStatus");
                TypedField<String> PROCESS_RESULT = new TypedField<>(String.class, "salesBill.processResult");
                TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "salesBill.processRemark");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "salesBill.purchaserAddress");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "salesBill.purchaserBankAccount");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "salesBill.purchaserBankName");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "salesBill.purchaserBankNameAccount");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "salesBill.purchaserName");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "salesBill.purchaserTaxNo");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "salesBill.purchaserTel");
                TypedField<String> SYS_ORG_CODE = new TypedField<>(String.class, "salesBill.sysOrgCode");
                TypedField<Long> ID = new TypedField<>(Long.class, "salesBill.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "salesBill.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "salesBill.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "salesBill.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "salesBill.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "salesBill.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "salesBill.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "salesBill.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "salesBill.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "salesBill.delete_flag");
                TypedField<Long> UPLOAD_COUNT = new TypedField<>(Long.class, "salesBill.uploadCount");
                TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "salesBill.taxRate");
                TypedField<String> SOURCE_SALES_BILL_NO = new TypedField<>(String.class, "salesBill.sourceSalesBillNo");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "salesBill.sellerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "salesBill.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "salesBill.ext2");
            }
        }
    }
    public interface ScannedDat {
        static Long id() {
            return 1409716522429652994L;
        }
        static String code() {
            return "scannedDat";
        }
        TypedField<String> FILE_NAME = new TypedField<>(String.class, "fileName");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "fileUrl");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SERIAL_NO = new TypedField<>(String.class, "serialNo");

    }
    public interface SourceData {
        static Long id() {
            return 1410424120694706177L;
        }
        static String code() {
            return "sourceData";
        }
        TypedField<String> DATA_TYPE = new TypedField<>(String.class, "dataType");
        TypedField<String> DATA_STRING = new TypedField<>(String.class, "dataString");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FILE_NAME_DATE = new TypedField<>(String.class, "fileNameDate");
        TypedField<Long> TRANSLATE_COUNT = new TypedField<>(Long.class, "translateCount");
        TypedField<String> BATCH_ID = new TypedField<>(String.class, "batchId");
        TypedField<Long> BATCH_COUNT = new TypedField<>(Long.class, "batchCount");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");

    }
    public interface DiscountRuleConfig {
        static Long id() {
            return 1411960673360076801L;
        }
        static String code() {
            return "discountRuleConfig";
        }
        TypedField<String> SALES_DISCOUNT = new TypedField<>(String.class, "salesDiscount");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_AMOUNT_TYPE = new TypedField<>(String.class, "invoiceAmountType");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> QUANTITY_DISCOUNT = new TypedField<>(String.class, "quantityDiscount");
        TypedField<String> CASH_DISCOUNT = new TypedField<>(String.class, "cashDiscount");
        TypedField<String> LOGISTIC_DISCOUNT = new TypedField<>(String.class, "logisticDiscount");
        TypedField<String> FIXED_DISCOUNT = new TypedField<>(String.class, "fixedDiscount");
        TypedField<String> MARKET_HYGIENE = new TypedField<>(String.class, "marketHygiene");
        TypedField<String> INFO_SHARING = new TypedField<>(String.class, "infoSharing");
        TypedField<String> VOLUME_DISC = new TypedField<>(String.class, "volumeDisc");

    }
    public interface SalesBillDetailCount {
        static Long id() {
            return 1414918609893191682L;
        }
        static String code() {
            return "salesBillDetailCount";
        }
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<Long> COUNT = new TypedField<>(Long.class, "count");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface TaskLog {
        static Long id() {
            return 1417748327069179905L;
        }
        static String code() {
            return "taskLog";
        }
        TypedField<String> METHOD_NAME = new TypedField<>(String.class, "methodName");
        TypedField<Long> PERFORM_TIME = new TypedField<>(Long.class, "performTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> MDC = new TypedField<>(String.class, "mdc");
        TypedField<String> ANNOTATION_PARAMS = new TypedField<>(String.class, "annotationParams");

    }
    public interface ExpectionLog {
        static Long id() {
            return 1418124149100244993L;
        }
        static String code() {
            return "expectionLog";
        }
        TypedField<String> OPERATION_ID = new TypedField<>(String.class, "operationId");
        TypedField<String> MDC = new TypedField<>(String.class, "mdc");
        TypedField<String> OPERATION_TYPE = new TypedField<>(String.class, "operationType");
        TypedField<String> MESSAGE = new TypedField<>(String.class, "message");
        TypedField<String> METHOD_NAME = new TypedField<>(String.class, "methodName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProductCodeConfig {
        static Long id() {
            return 1423505938922643457L;
        }
        static String code() {
            return "productCodeConfig";
        }
        TypedField<String> PRODUCT_CODE = new TypedField<>(String.class, "productCode");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface ProductNameKeyword {
        static Long id() {
            return 1423507127525482498L;
        }
        static String code() {
            return "productNameKeyword";
        }
        TypedField<Long> SERIAL_NUMBER = new TypedField<>(Long.class, "serialNumber");
        TypedField<String> KEYWORD = new TypedField<>(String.class, "keyword");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "taxConvertCode");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
    public interface SalesBillRecord {
        static Long id() {
            return 1448939796760203266L;
        }
        static String code() {
            return "salesBillRecord";
        }
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> EXECUTION_PHASE = new TypedField<>(String.class, "executionPhase");
        TypedField<String> MSG = new TypedField<>(String.class, "msg");
        TypedField<String> TRACED_ID = new TypedField<>(String.class, "tracedId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");

    }
}
