package com.xforceplus.ultraman.app.jccqyy.controller;


/**
 * 公司映射feign客户端
 *
 * @author ultraman
 * @date 2022-10-24
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jccqyy.entity.CqpCompanyMapping;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-cqyy")
public interface CqpCompanyMappingFeignApi {

  /**
   * 通过id查询公司映射
   * @param  id
   * @return R
   */
  @GetMapping("/cqpCompanyMapping/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增公司映射
   * @param cqpCompanyMapping 公司映射
   * @return R
   */
  @PostMapping("/cqpCompanyMapping/add")
  public R save(@RequestBody CqpCompanyMapping cqpCompanyMapping);

  /**
   * 修改公司映射
   * @param cqpCompanyMapping 公司映射
   * @return R
   */
  @PostMapping("/cqpCompanyMapping/update")
  public R updateById(@RequestBody CqpCompanyMapping cqpCompanyMapping);

  /**
   * 通过id删除公司映射
   * @param  id
   * @return R
   */
  @DeleteMapping("/cqpCompanyMapping/del/{id}" )
  public R removeById(@PathVariable Long id);

}